/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryLanguageType;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryIDN
implements EPPCodecComponent {
    private static final long serialVersionUID = -8068272628369235117L;
    public static final String ELM_NAME = "registry:idn";
    public static final String ELM_IDN_VERSION = "registry:idnVersion";
    public static final String ELM_IDNA_VERSION = "registry:idnaVersion";
    public static final String ELM_UNICODE_VERSION = "registry:unicodeVersion";
    public static final String ELM_ENCODING = "registry:encoding";
    public static final String ELM_COMMINGLE_ALLOWED = "registry:commingleAllowed";
    private String idnVersion = null;
    private String idnaVersion = null;
    private String unicodeVersion = null;
    private Boolean commingleAllowed = Boolean.FALSE;
    private String encoding = "Punycode";
    private List languages = new ArrayList();

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryIDN.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        if (this.idnVersion != null && this.idnVersion.trim().length() > 0) {
            EPPUtil.encodeString(aDocument, root, this.idnVersion, "http://www.verisign.com/epp/registry-1.0", ELM_IDN_VERSION);
        }
        EPPUtil.encodeString(aDocument, root, this.idnaVersion, "http://www.verisign.com/epp/registry-1.0", ELM_IDNA_VERSION);
        EPPUtil.encodeString(aDocument, root, this.unicodeVersion, "http://www.verisign.com/epp/registry-1.0", ELM_UNICODE_VERSION);
        if (this.encoding == null && this.encoding.trim().length() == 0) {
            this.encoding = "Punycode";
        }
        EPPUtil.encodeString(aDocument, root, this.encoding, "http://www.verisign.com/epp/registry-1.0", ELM_ENCODING);
        if (this.commingleAllowed == null) {
            this.commingleAllowed = Boolean.FALSE;
        }
        EPPUtil.encodeString(aDocument, root, this.commingleAllowed.toString(), "http://www.verisign.com/epp/registry-1.0", ELM_COMMINGLE_ALLOWED);
        if (this.languages != null && this.languages.size() > 0) {
            EPPUtil.encodeCompList(aDocument, root, this.languages);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.idnVersion = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_IDN_VERSION);
        this.idnaVersion = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_IDNA_VERSION);
        this.unicodeVersion = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_UNICODE_VERSION);
        this.encoding = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_ENCODING);
        if (this.encoding == null && this.encoding.trim().length() == 0) {
            this.encoding = "Punycode";
        }
        this.commingleAllowed = EPPUtil.decodeBoolean(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_COMMINGLE_ALLOWED);
        if (this.commingleAllowed == null) {
            this.commingleAllowed = Boolean.FALSE;
        }
        this.languages = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:language", EPPRegistryLanguageType.class);
    }

    void validateState() throws EPPCodecException {
        if (this.unicodeVersion == null || this.unicodeVersion.trim().length() == 0) {
            throw new EPPCodecException("unicodeVersion element is not set");
        }
        if (this.idnaVersion == null || this.idnaVersion.trim().length() == 0) {
            throw new EPPCodecException("idnaVersion element is not set");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRegistryIDN clone = (EPPRegistryIDN)super.clone();
        if (this.languages != null) {
            clone.languages = (List)((ArrayList)this.languages).clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryIDN)) {
            return false;
        }
        EPPRegistryIDN theComp = (EPPRegistryIDN)aObject;
        if (!(this.idnVersion != null ? this.idnVersion.equals(theComp.idnVersion) : theComp.idnVersion == null)) {
            return false;
        }
        if (!(this.idnaVersion != null ? this.idnaVersion.equals(theComp.idnaVersion) : theComp.idnaVersion == null)) {
            return false;
        }
        if (!(this.unicodeVersion != null ? this.unicodeVersion.equals(theComp.unicodeVersion) : theComp.unicodeVersion == null)) {
            return false;
        }
        if (!(this.encoding != null ? this.encoding.equals(theComp.encoding) : theComp.encoding == null)) {
            return false;
        }
        if (!(this.commingleAllowed != null ? this.commingleAllowed.equals(theComp.commingleAllowed) : theComp.commingleAllowed == null)) {
            return false;
        }
        return this.languages != null ? EPPUtil.equalLists(this.languages, theComp.languages) : theComp.languages == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getIdnVersion() {
        return this.idnVersion;
    }

    public void setIdnVersion(String idnVersion) {
        this.idnVersion = idnVersion;
    }

    public String getUnicodeVersion() {
        return this.unicodeVersion;
    }

    public void setUnicodeVersion(String unicodeVersion) {
        this.unicodeVersion = unicodeVersion;
    }

    public String getIdnaVersion() {
        return this.idnaVersion;
    }

    public void setIdnaVersion(String idnaVersion) {
        this.idnaVersion = idnaVersion;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean getCommingleAllowed() {
        return this.commingleAllowed;
    }

    public void setCommingleAllowed(Boolean commingleAllowed) {
        this.commingleAllowed = commingleAllowed;
    }

    public List getLanguages() {
        return this.languages;
    }

    public void setLanguages(List languages) {
        this.languages = languages;
    }

    public void addLanguage(EPPRegistryLanguageType language) {
        if (this.languages == null) {
            this.languages = new ArrayList();
        }
        this.languages.add(language);
    }
}

