/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryKeyValue;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryCustomData
implements EPPCodecComponent {
    private static final long serialVersionUID = 1009798850579739560L;
    public static final String ELM_NAME = "registry:customData";
    private List keyValues = new ArrayList();

    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.keyValues == null || this.keyValues.size() == 0) {
            throw new EPPEncodeException("Invalid state on EPPRegistryCustomData.encode: keyValues is required");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        for (EPPRegistryKeyValue elem : this.keyValues) {
            root.appendChild(elem.encode(aDocument));
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.keyValues = EPPUtil.decodeCompList(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:value", EPPRegistryKeyValue.class);
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRegistryCustomData clone = (EPPRegistryCustomData)super.clone();
        if (this.keyValues != null) {
            clone.keyValues = (List)((ArrayList)this.keyValues).clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryCustomData)) {
            return false;
        }
        EPPRegistryCustomData theComp = (EPPRegistryCustomData)aObject;
        return this.keyValues != null ? EPPUtil.equalLists(this.keyValues, theComp.keyValues) : theComp.keyValues == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public List getKeyValues() {
        return this.keyValues;
    }

    public void setKeyValues(List keyValues) {
        this.keyValues = keyValues;
    }

    public void addKeyValue(EPPRegistryKeyValue keyValue) {
        if (keyValue == null) {
            return;
        }
        if (this.keyValues == null) {
            this.keyValues = new ArrayList();
        }
        this.keyValues.add(keyValue);
    }
}

