/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryCreateResp
extends EPPResponse {
    private static final long serialVersionUID = 4209738019189546774L;
    static final String ELM_NAME = "registry:creData";
    private static final String ELM_REGISTRY_NAME = "registry:name";
    private static final String ELM_CREATION_DATE = "registry:crDate";
    private String name = null;
    private Date createDate = null;

    public EPPRegistryCreateResp() {
    }

    public EPPRegistryCreateResp(EPPTransId aTransId, String name) {
        super(aTransId);
        this.name = name;
    }

    public EPPRegistryCreateResp(EPPTransId aTransId, String name, Date createDate) {
        this(aTransId, name);
        this.createDate = createDate;
    }

    public String getType() {
        return ELM_NAME;
    }

    public String getNamespace() {
        return "http://www.verisign.com/epp/registry-1.0";
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryCreateResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPRegistryCreateResp theComp = (EPPRegistryCreateResp)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        return this.createDate != null ? this.createDate.equals(theComp.createDate) : theComp.createDate == null;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRegistryCreateResp clone = (EPPRegistryCreateResp)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.createDate == null) {
            throw new EPPCodecException("required attribute createDate is not set");
        }
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryCreateResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        root.setAttribute("xmlns:registry", "http://www.verisign.com/epp/registry-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.verisign.com/epp/registry-1.0 registry-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_NAME);
        EPPUtil.encodeTimeInstant(aDocument, root, this.createDate, "http://www.verisign.com/epp/registry-1.0", ELM_CREATION_DATE);
        return root;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_REGISTRY_NAME);
        this.createDate = EPPUtil.decodeTimeInstant(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_CREATION_DATE);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPRegistryCreateResp.decode: " + e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
}

