/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.namestoreext;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateResp;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.codec.host.EPPHostCreateCmd;
import com.verisign.epp.codec.host.EPPHostCreateResp;
import com.verisign.epp.codec.namestoreext.EPPNamestoreExtNamestoreExt;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPNamestoreExtTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPNamestoreExtTst(String name) {
        super(name);
    }

    public void testNamestoreExtNamestoreExt() {
        EPPCodecTst.printStart("testNSProductProduct");
        EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
        Vector<EPPHostAddress> theHosts = new Vector<EPPHostAddress>();
        theHosts.addElement(new EPPHostAddress("192.1.2.3"));
        theHosts.addElement(new EPPHostAddress("192.1.2.4"));
        EPPHostCreateCmd theHostCommand = new EPPHostCreateCmd("ABC-12345", "ns1.example.com", theHosts);
        theHostCommand.addExtension(new EPPNamestoreExtNamestoreExt("dottv"));
        EPPEncodeDecodeStats theStats = EPPCodecTst.testEncodeDecode(theHostCommand);
        System.out.println(theStats);
        EPPHostCreateResp theHostResponse = new EPPHostCreateResp(respTransId, "ns1.example.com", new Date());
        theHostResponse.setResult(1000);
        theHostResponse.addExtension(new EPPNamestoreExtNamestoreExt("dottv"));
        theStats = EPPCodecTst.testEncodeDecode(theHostResponse);
        System.out.println(theStats);
        EPPDomainCreateCmd theDomainCommand = new EPPDomainCreateCmd("ABC-12345", "john.doe.name", new EPPAuthInfo("2fooBAR"));
        theDomainCommand.addExtension(new EPPNamestoreExtNamestoreExt("dottv"));
        theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
        System.out.println(theStats);
        EPPDomainCreateResp theDomainResponse = new EPPDomainCreateResp(respTransId, "john.doe.name", new GregorianCalendar(2001, 5, 5).getTime(), new Date());
        theDomainResponse.setResult(1000);
        theDomainResponse.addExtension(new EPPNamestoreExtNamestoreExt("dottv"));
        theStats = EPPCodecTst.testEncodeDecode(theDomainResponse);
        System.out.println(theStats);
        EPPCodecTst.printEnd("testNamestoreExtNamestoreExt");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPNamestoreExtTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
            EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.namestoreext.EPPNamestoreExtExtFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding factories to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPNamestoreExtTst Thread " + i, EPPNamestoreExtTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPNamestoreExtTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

