/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchPhase;
import com.verisign.epp.codec.launch.EPPLaunchStatus;
import com.verisign.epp.codec.mark.EPPMark;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchInfData
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLaunchInfData.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "infData";
    public static final String ELM_NAME = "launch:infData";
    private static final String ELM_APPLICATION_ID = "applicationID";
    private static final String ELM_STATUS = "status";
    EPPLaunchPhase phase;
    String applicationId;
    EPPLaunchStatus status;
    List<EPPMark> marks = new ArrayList<EPPMark>();

    public EPPLaunchInfData() {
    }

    public EPPLaunchInfData(EPPLaunchPhase aPhase, List<EPPMark> aMarks) {
        this.phase = aPhase;
        this.marks = aMarks;
    }

    public EPPLaunchInfData(EPPLaunchPhase aPhase, EPPMark aMark) {
        this.phase = aPhase;
        this.setMark(aMark);
    }

    public EPPLaunchInfData(EPPLaunchPhase aPhase, String aApplicationId, EPPLaunchStatus aStatus) {
        this.phase = aPhase;
        this.applicationId = aApplicationId;
        this.status = aStatus;
    }

    public EPPLaunchInfData(EPPLaunchPhase aPhase, String aApplicationId, EPPLaunchStatus aStatus, List<EPPMark> aMarks) {
        this.phase = aPhase;
        this.applicationId = aApplicationId;
        this.status = aStatus;
        this.marks = aMarks;
    }

    public EPPLaunchInfData(EPPLaunchPhase aPhase, String aApplicationId, EPPLaunchStatus aStatus, EPPMark aMark) {
        this.phase = aPhase;
        this.applicationId = aApplicationId;
        this.status = aStatus;
        this.setMark(aMark);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchInfData clone = (EPPLaunchInfData)super.clone();
        clone.applicationId = this.applicationId;
        clone.phase = this.phase == null ? null : (EPPLaunchPhase)this.phase.clone();
        clone.status = this.status == null ? null : (EPPLaunchStatus)this.status.clone();
        if (this.marks != null) {
            clone.marks = new ArrayList<EPPMark>(this.marks);
        }
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchInfData.encode(Document)");
        }
        if (this.phase == null) {
            throw new EPPEncodeException("EPPLaunchInfData phase attribute must be set.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, root, this.phase);
        EPPUtil.encodeString(aDocument, root, this.applicationId, "urn:ietf:params:xml:ns:launch-1.0", "launch:applicationID");
        EPPUtil.encodeComp(aDocument, root, this.status);
        EPPUtil.encodeCompList(aDocument, root, this.marks);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.phase = (EPPLaunchPhase)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:phase", EPPLaunchPhase.class);
        if (this.phase == null) {
            throw new EPPDecodeException("EPPLaunchInfo phase element not found.");
        }
        this.applicationId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_APPLICATION_ID);
        this.status = (EPPLaunchStatus)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:launch-1.0", "launch:status", EPPLaunchStatus.class);
        this.marks = EPPUtil.decodeCompList(aElement, "urn:ietf:params:xml:ns:mark-1.0", "mark:mark", EPPMark.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchInfData)) {
            cat.error((Object)("EPPLaunchInfData.equals(): " + aObject.getClass().getName() + " not EPPLaunchInfData instance"));
            return false;
        }
        EPPLaunchInfData other = (EPPLaunchInfData)aObject;
        if (!EqualityUtil.equals(this.phase, other.phase)) {
            cat.error((Object)"EPPLaunchInfo.equals(): phase not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.applicationId, other.applicationId)) {
            cat.error((Object)"EPPLaunchInfo.equals(): applicationId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.status, other.status)) {
            cat.error((Object)"EPPLaunchInfo.equals(): status not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.marks, other.marks)) {
            cat.error((Object)"EPPLaunchInfo.equals(): marks not equal");
            return false;
        }
        return true;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String aApplicationId) {
        this.applicationId = aApplicationId;
    }

    public EPPLaunchPhase getPhase() {
        return this.phase;
    }

    public void setPhase(EPPLaunchPhase aPhase) {
        this.phase = aPhase;
    }

    public EPPLaunchStatus getStatus() {
        return this.status;
    }

    public void setStatus(EPPLaunchStatus aStatus) {
        this.status = aStatus;
    }

    public void setStatus(String aStatusString) {
        this.status = aStatusString == null ? null : new EPPLaunchStatus(aStatusString);
    }

    public void setPhase(String aPhaseString) {
        this.phase = new EPPLaunchPhase(aPhaseString);
    }

    public void setMark(EPPMark aMark) {
        this.marks = new ArrayList<EPPMark>();
        this.marks.add(aMark);
    }

    public EPPMark getMark() {
        if (this.marks == null || this.marks.isEmpty()) {
            return null;
        }
        return this.marks.get(0);
    }

    public void addMark(EPPMark aMark) {
        if (this.marks == null) {
            this.marks = new ArrayList<EPPMark>();
        }
        this.marks.add(aMark);
    }

    public List<EPPMark> getMarks() {
        return this.marks;
    }

    public void setMarks(List<EPPMark> aMarks) {
        this.marks = aMarks;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

