/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.mark.EPPMark;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchCodeMark
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLaunchCodeMark.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "codeMark";
    public static final String ELM_NAME = "launch:codeMark";
    private static final String ELM_CODE = "code";
    String code;
    EPPMark mark;

    public EPPLaunchCodeMark() {
    }

    public EPPLaunchCodeMark(String aCode) {
        this.code = aCode;
    }

    public EPPLaunchCodeMark(EPPMark aMark) {
        this.mark = aMark;
    }

    public EPPLaunchCodeMark(String aCode, EPPMark aMark) {
        this.code = aCode;
        this.mark = aMark;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchCodeMark clone = (EPPLaunchCodeMark)super.clone();
        if (this.mark != null) {
            clone.mark = (EPPMark)this.mark.clone();
        }
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchCodeMark.encode(Document)");
        }
        if (this.code == null && this.mark == null) {
            throw new EPPEncodeException("Both the codeMark attributes are not set.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.code, "urn:ietf:params:xml:ns:launch-1.0", "launch:code");
        EPPUtil.encodeComp(aDocument, root, this.mark);
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.code = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_CODE);
        this.mark = (EPPMark)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:mark-1.0", "mark", EPPMark.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchCodeMark)) {
            cat.error((Object)"EPPLaunchCodeMark.equals(): aObject is not an EPPLaunchCodeMark");
            return false;
        }
        EPPLaunchCodeMark other = (EPPLaunchCodeMark)aObject;
        if (!EqualityUtil.equals(this.code, other.code)) {
            cat.error((Object)"EPPLaunchCodeMark.equals(): code not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.mark, other.mark)) {
            cat.error((Object)"EPPMark.equals(): mark not equal");
            return false;
        }
        return true;
    }

    public boolean hasCodeMark() {
        return this.code != null && this.mark != null;
    }

    public boolean hasCode() {
        return this.code != null;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String aCode) {
        this.code = aCode;
    }

    public boolean hasMark() {
        return this.mark != null;
    }

    public EPPMark getMark() {
        return this.mark;
    }

    public void setMark(EPPMark aMark) {
        this.mark = aMark;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

