/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPLaunchCheckResult
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLaunchCheckResult.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "cd";
    public static final String ELM_NAME = "launch:cd";
    private static final String ELM_DOMAIN_NAME = "name";
    private static final String ELM_CLAIM_KEY = "claimKey";
    private static final String ATTR_EXISTS = "exists";
    private String name;
    private boolean exists = true;
    private String claimKey;

    public EPPLaunchCheckResult() {
    }

    public EPPLaunchCheckResult(String aName, boolean aExists) {
        this.name = aName;
        this.exists = aExists;
    }

    public EPPLaunchCheckResult(String aName, boolean aExists, String aClaimKey) {
        this.name = aName;
        this.exists = aExists;
        this.claimKey = aClaimKey;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchCheckResult.encode(Document)");
        }
        if (this.name == null) {
            throw new EPPEncodeException("EPPLaunchCheckResult name attribute must be set.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", "launch:name");
        root.appendChild(nameElm);
        Text textNode = aDocument.createTextNode(this.name);
        nameElm.appendChild(textNode);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_EXISTS, this.exists);
        EPPUtil.encodeString(aDocument, root, this.claimKey, "urn:ietf:params:xml:ns:launch-1.0", "launch:claimKey");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_DOMAIN_NAME);
        Element currElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_DOMAIN_NAME);
        if (currElm != null) {
            this.exists = EPPUtil.decodeBooleanAttr(currElm, ATTR_EXISTS);
        }
        this.claimKey = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_CLAIM_KEY);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchCheckResult)) {
            cat.error((Object)"EPPLaunchCheckResult.equals(): aObject is not an EPPLaunchCheckResult");
            return false;
        }
        EPPLaunchCheckResult other = (EPPLaunchCheckResult)aObject;
        if (!EqualityUtil.equals(this.name, other.name)) {
            cat.error((Object)"EPPLaunchCheckResult.equals(): name not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.exists, other.exists)) {
            cat.error((Object)"EPPLaunchCheckResult.equals(): exists not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.claimKey, other.claimKey)) {
            cat.error((Object)"EPPLaunchCheckResult.equals(): claimKey not equal");
            return false;
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchCheckResult clone = null;
        clone = (EPPLaunchCheckResult)super.clone();
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExists(boolean aExists) {
        this.exists = aExists;
    }

    public String getClaimKey() {
        return this.claimKey;
    }

    public void setClaimKey(String aClaimKey) {
        this.claimKey = aClaimKey;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

