/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.host.EPPHostAddRemove;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.codec.host.EPPHostCheckCmd;
import com.verisign.epp.codec.host.EPPHostCheckResp;
import com.verisign.epp.codec.host.EPPHostCheckResult;
import com.verisign.epp.codec.host.EPPHostCreateCmd;
import com.verisign.epp.codec.host.EPPHostCreateResp;
import com.verisign.epp.codec.host.EPPHostDeleteCmd;
import com.verisign.epp.codec.host.EPPHostInfoCmd;
import com.verisign.epp.codec.host.EPPHostInfoResp;
import com.verisign.epp.codec.host.EPPHostPendActionMsg;
import com.verisign.epp.codec.host.EPPHostStatus;
import com.verisign.epp.codec.host.EPPHostUpdateCmd;
import com.verisign.epp.util.TestThread;
import java.util.Date;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class EPPHostTst
extends TestCase {
    private static long numIterations = 1L;

    public EPPHostTst(String name) {
        super(name);
    }

    public void testHostInfo() {
        EPPCodecTst.printStart("testHostInfo");
        EPPHostInfoCmd theCommand = new EPPHostInfoCmd("ABC-12345", "ns1.example.com");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPHostInfoResp theResponse = new EPPHostInfoResp(respTransId, "ns1.example.com", "NS1EXAMPLE1-VRSN", new EPPHostStatus("pendingTransfer"), "ClientY", "ClientX", new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        Vector<EPPHostAddress> addresses = new Vector<EPPHostAddress>();
        addresses.addElement(new EPPHostAddress("192.1.2.3", 0));
        addresses.addElement(new EPPHostAddress("1080:0:0:0:8:800:200C:417A", 1));
        theResponse.setAddresses(addresses);
        theResponse.setLastUpdatedBy("ClientX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setTrDate(new Date());
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testHostInfo");
    }

    public void testHostPendActionMsg() {
        EPPCodecTst.printStart("testHostPendActionMsg");
        EPPTransId thePollTransId = new EPPTransId("ABC-12349", "54321-XYZ");
        EPPTransId thePendingTransId = new EPPTransId("DEF-12349", "12345-XYZ");
        EPPHostPendActionMsg theMsg = new EPPHostPendActionMsg(thePollTransId, "ns1.example.com", true, thePendingTransId, new Date());
        theMsg.setResult(1301);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theMsg);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testHostPendActionMsg");
    }

    public void testHostCreate() {
        EPPCodecTst.printStart("testHostCreate");
        EPPHostCreateCmd theCommand = new EPPHostCreateCmd("ABC-12345", "ns1.example.com");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<EPPHostAddress> addresses = new Vector<EPPHostAddress>();
        addresses.addElement(new EPPHostAddress("192.1.2.3"));
        addresses.addElement(new EPPHostAddress("198.1.2.3", 0));
        addresses.addElement(new EPPHostAddress("1080:0:0:0:8:800:200C:417A", 1));
        addresses.addElement(new EPPHostAddress("::FFFF:129.144.52.38", 1));
        theCommand = new EPPHostCreateCmd("ABC-12345", "ns1.example.com", addresses);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPHostCreateResp theResponse = new EPPHostCreateResp(respTransId, "ns1.example.com", new Date());
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testHostCreate");
    }

    public void testHostDelete() {
        EPPCodecTst.printStart("testHostDelete");
        EPPHostDeleteCmd theCommand = new EPPHostDeleteCmd("ABC-12345", "ns1.example.com");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testHostDelete");
    }

    public void testHostUpdate() {
        EPPHostUpdateCmd theCommand = null;
        EPPEncodeDecodeStats commandStats = null;
        EPPCodecTst.printStart("testHostUpdate");
        Vector<EPPHostAddress> addAddresses = new Vector<EPPHostAddress>();
        addAddresses.addElement(new EPPHostAddress("192.1.2.3"));
        Vector<EPPHostAddress> removeAddresses = new Vector<EPPHostAddress>();
        removeAddresses.addElement(new EPPHostAddress("1080:0:0:0:8:800:200C:417A", 1));
        Vector<EPPHostStatus> addStatuses = new Vector<EPPHostStatus>();
        addStatuses.addElement(new EPPHostStatus("clientDeleteProhibited", "Hello World", "en"));
        addStatuses.addElement(new EPPHostStatus("clientUpdateProhibited"));
        EPPHostAddRemove addItems = new EPPHostAddRemove(addAddresses, addStatuses);
        EPPHostAddRemove removeItems = new EPPHostAddRemove(removeAddresses);
        EPPHostAddRemove changeItems = new EPPHostAddRemove("ns2.example.com");
        theCommand = new EPPHostUpdateCmd("ABC-12345", "ns1.example.com", addItems, removeItems, changeItems);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPResponse theResponse = new EPPResponse(respTransId);
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testHostUpdate");
    }

    public void testHostCheck() {
        EPPCodecTst.printStart("testHostCheck");
        EPPHostCheckCmd theCommand = new EPPHostCheckCmd("ABC-12345", "ns1.example.com");
        EPPEncodeDecodeStats commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        Vector<String> hosts = new Vector<String>();
        hosts.addElement("ns1.example.com");
        hosts.addElement("ns2.example.com");
        hosts.addElement("ns3.example.com");
        theCommand = new EPPHostCheckCmd("ABC-12345", hosts);
        commandStats = EPPCodecTst.testEncodeDecode(theCommand);
        System.out.println(commandStats);
        EPPTransId respTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPHostCheckResp theResponse = new EPPHostCheckResp(respTransId, new EPPHostCheckResult("ns1.david.com", true));
        theResponse.setResult(1000);
        EPPEncodeDecodeStats responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        Vector<EPPHostCheckResult> hostResults = new Vector<EPPHostCheckResult>();
        hostResults.addElement(new EPPHostCheckResult("ns1.example.com", true));
        EPPHostCheckResult hostResult = new EPPHostCheckResult("example2.com", false);
        hostResult.setHostReason("In Use");
        hostResult.setLanguage("fr");
        hostResults.addElement(hostResult);
        hostResults.addElement(new EPPHostCheckResult("ns3.example.com", true));
        theResponse = new EPPHostCheckResp(respTransId, hostResults);
        theResponse.setResult(1000);
        responseStats = EPPCodecTst.testEncodeDecode(theResponse);
        System.out.println(responseStats);
        EPPCodecTst.printEnd("testHostCheck");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        EPPCodecTst.initEnvironment();
        TestSuite suite = new TestSuite(EPPHostTst.class);
        String numIterProp = System.getProperty("iterations");
        if (numIterProp != null) {
            numIterations = Integer.parseInt(numIterProp);
        }
        try {
            EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
        }
        catch (EPPCodecException e) {
            Assert.fail((String)("EPPCodecException adding EPPHostMapFactory to EPPCodec: " + e));
        }
        return suite;
    }

    public static void main(String[] args) {
        int numThreads = 1;
        String threadsStr = System.getProperty("threads");
        if (threadsStr != null) {
            numThreads = Integer.parseInt(threadsStr);
        }
        if (numThreads > 1) {
            for (int i = 0; i < numThreads; ++i) {
                TestThread thread = new TestThread("EPPHostTst Thread " + i, EPPHostTst.suite());
                thread.start();
            }
        } else {
            TestRunner.run((Test)EPPHostTst.suite());
        }
    }

    public static void setNumIterations(long aNumIterations) {
        numIterations = aNumIterations;
    }
}

