/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPMessage;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EPPProtocolExtension
implements EPPMessage {
    static final String ELM_NAME = "extension";

    public abstract String getNamespace();

    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        Element extElm = this.doEncode(aDocument);
        if (extElm != null) {
            root.appendChild(extElm);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        Element extensionTypeElm = EPPUtil.getFirstElementChild(aElement);
        if (extensionTypeElm == null) {
            throw new EPPDecodeException("No child protocol extension Element found");
        }
        this.doDecode(extensionTypeElm);
    }

    public boolean equals(Object aObject) {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPProtocolExtension clone = null;
        clone = (EPPProtocolExtension)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    protected abstract Element doEncode(Document var1) throws EPPEncodeException;

    protected abstract void doDecode(Element var1) throws EPPDecodeException;
}

