/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPPollCmd
extends EPPCommand {
    public static final String OP_REQ = "req";
    public static final String OP_ACK = "ack";
    static final String ELM_NAME = "poll";
    private static final String ATTR_OP = "op";
    private static final String ATTR_MSGID = "msgID";
    protected String op = null;
    protected String msgID = null;

    public EPPPollCmd() {
        this.op = null;
        this.msgID = null;
    }

    public EPPPollCmd(String aTransId, String aOp) {
        super(aTransId);
        this.op = aOp;
        this.msgID = null;
    }

    public EPPPollCmd(String aTransId, String aOp, String aMsgID) {
        super(aTransId);
        this.op = aOp;
        this.msgID = aMsgID;
    }

    public String getType() {
        return ELM_NAME;
    }

    public String getOp() {
        return this.op;
    }

    public boolean equals(Object aObject) {
        EPPPollCmd thePoll = (EPPPollCmd)aObject;
        if (!super.equals(aObject)) {
            return false;
        }
        if (!(this.op != null ? this.op.equals(thePoll.op) : thePoll.op == null)) {
            return false;
        }
        return this.msgID != null ? this.msgID.equals(thePoll.msgID) : thePoll.msgID == null;
    }

    protected Element doGenEncode(Document aDocument) throws EPPEncodeException {
        if (this.op == null) {
            throw new EPPEncodeException("EPPPollCmd op attribute is null");
        }
        if (!this.op.equals(OP_ACK) && !this.op.equals(OP_REQ)) {
            throw new EPPEncodeException("EPPPollCmd invalid operation type of " + this.op);
        }
        if (this.op.equals(OP_ACK) && this.msgID == null) {
            throw new EPPEncodeException("EPPPollCmd msgId attribute is null for ACK operation");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        root.setAttribute(ATTR_OP, this.op);
        Element mapElement = this.doEncode(aDocument);
        if (mapElement != null) {
            root.appendChild(mapElement);
        }
        if (this.msgID != null) {
            root.setAttribute(ATTR_MSGID, this.msgID);
        }
        return root;
    }

    protected void doGenDecode(Element aElement) throws EPPDecodeException {
        this.op = aElement.getAttribute(ATTR_OP);
        if (this.op == null) {
            throw new EPPDecodeException("EPPPollCmd requires an \"op\" attribute");
        }
        this.doDecode(aElement);
        this.msgID = aElement.getAttribute(ATTR_MSGID).equals("") ? null : aElement.getAttribute(ATTR_MSGID);
    }

    public Object clone() throws CloneNotSupportedException {
        EPPPollCmd clone = null;
        clone = (EPPPollCmd)super.clone();
        return clone;
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        return null;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
    }

    public String getMsgID() {
        return this.msgID;
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:epp-1.0";
    }

    public void setMsgID(String aMsgID) {
        this.msgID = aMsgID;
    }
}

