/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.emailFwd;

import com.verisign.epp.codec.emailFwd.EPPEmailFwdContact;
import com.verisign.epp.codec.emailFwd.EPPEmailFwdPeriod;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCreateCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPEmailFwdCreateCmd
extends EPPCreateCmd {
    static final String ELM_NAME = "emailFwd:create";
    private static final String ELM_EMAILFWD_NAME = "emailFwd:name";
    private static final String ELM_EMAILFWD_TO = "emailFwd:fwdTo";
    private static final String ELM_REGISTRANT = "emailFwd:registrant";
    private static final String ELM_CONTACT = "emailFwd:contact";
    private String name = null;
    private String forwardTo = null;
    private EPPEmailFwdPeriod period = null;
    private Vector contacts = null;
    private EPPAuthInfo authInfo = null;
    private String registrant = null;

    public EPPEmailFwdCreateCmd() {
        this.name = null;
        this.forwardTo = null;
        this.period = null;
        this.contacts = null;
    }

    public EPPEmailFwdCreateCmd(String aTransId, String aName, String aForwardTo, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.name = aName;
        this.forwardTo = aForwardTo;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("http://www.nic.name/epp/emailFwd-1.0", "emailFwd:authInfo");
        this.period = null;
        this.contacts = null;
    }

    public EPPEmailFwdCreateCmd(String aTransId, String aName, String aForwardTo, Vector someContacts, EPPEmailFwdPeriod aPeriod, EPPAuthInfo aAuthInfo) {
        super(aTransId);
        this.name = aName;
        this.forwardTo = aForwardTo;
        this.period = aPeriod;
        this.contacts = someContacts;
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("http://www.nic.name/epp/emailFwd-1.0", "emailFwd:authInfo");
    }

    public String getNamespace() {
        return "http://www.nic.name/epp/emailFwd-1.0";
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
        if (this.forwardTo == null) {
            throw new EPPCodecException("forwardTo required attribute is not set");
        }
        if (this.authInfo == null) {
            throw new EPPCodecException("authInfo required attribute is not set");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setForwardTo(String aForwardTo) {
        this.forwardTo = aForwardTo;
    }

    public Vector getContacts() {
        return this.contacts;
    }

    public void setContacts(Vector aContacts) {
        this.contacts = aContacts;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPEmailFwdCreateCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPEmailFwdCreateCmd theComp = (EPPEmailFwdCreateCmd)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        if (!(this.forwardTo != null ? this.forwardTo.equals(theComp.forwardTo) : theComp.forwardTo == null)) {
            return false;
        }
        if (!(this.period != null ? this.period.equals(theComp.period) : theComp.period == null)) {
            return false;
        }
        if (!(this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null)) {
            return false;
        }
        if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0") && !EPPUtil.equalVectors(this.contacts, theComp.contacts)) {
            return false;
        }
        return this.registrant != null ? this.registrant.equals(theComp.registrant) : theComp.registrant == null;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPEmailFwdCreateCmd clone = (EPPEmailFwdCreateCmd)super.clone();
        if (this.contacts != null) {
            clone.contacts = (Vector)this.contacts.clone();
            for (int i = 0; i < this.contacts.size(); ++i) {
                clone.contacts.setElementAt(((EPPEmailFwdContact)this.contacts.elementAt(i)).clone(), i);
            }
        }
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.period != null) {
            clone.period = (EPPEmailFwdPeriod)this.period.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public EPPEmailFwdPeriod getPeriod() {
        return this.period;
    }

    public String getRegistrant() {
        return this.registrant;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("http://www.nic.name/epp/emailFwd-1.0", "emailFwd:authInfo");
        }
    }

    public void setPeriod(EPPEmailFwdPeriod aPeriod) {
        this.period = aPeriod;
    }

    public void setRegistrant(String newRegistrant) {
        this.registrant = newRegistrant;
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPEmailFwdCreateCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_NAME);
        root.setAttribute("xmlns:emailFwd", "http://www.nic.name/epp/emailFwd-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.nic.name/epp/emailFwd-1.0 emailFwd-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_NAME);
        EPPUtil.encodeString(aDocument, root, this.forwardTo, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_TO);
        if (this.period != null && !this.period.isPeriodUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.period);
        }
        if (this.registrant != null) {
            EPPUtil.encodeString(aDocument, root, this.registrant, "http://www.nic.name/epp/emailFwd-1.0", ELM_REGISTRANT);
        }
        if (this.contacts != null) {
            if (EPPFactory.getInstance().hasService("urn:ietf:params:xml:ns:contact-1.0")) {
                EPPUtil.encodeCompVector(aDocument, root, this.contacts);
            } else {
                throw new EPPEncodeException("Contacts specified when the Contact Mapping is not supported");
            }
        }
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        return root;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_NAME);
        this.forwardTo = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_EMAILFWD_TO);
        this.period = (EPPEmailFwdPeriod)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/emailFwd-1.0", "emailFwd:period", EPPEmailFwdPeriod.class);
        this.registrant = EPPUtil.decodeString(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_REGISTRANT);
        this.contacts = EPPUtil.decodeCompVector(aElement, "http://www.nic.name/epp/emailFwd-1.0", ELM_CONTACT, EPPEmailFwdContact.class);
        if (this.contacts.size() == 0) {
            this.contacts = null;
        }
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "http://www.nic.name/epp/emailFwd-1.0", "emailFwd:authInfo", EPPAuthInfo.class);
    }
}

