/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.emailFwd;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPEmailFwdContact
implements EPPCodecComponent {
    public static final String TYPE_ADMINISTRATIVE = "admin";
    public static final String TYPE_BILLING = "billing";
    public static final String TYPE_TECHNICAL = "tech";
    static final String ELM_NAME = "emailFwd:contact";
    private static final String ATTR_TYPE = "type";
    private String type;
    private String name;

    public EPPEmailFwdContact() {
        this.name = null;
        this.type = null;
    }

    public EPPEmailFwdContact(String aName, String aType) {
        this.name = aName;
        this.type = aType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("http://www.nic.name/epp/emailFwd-1.0", ELM_NAME);
        if (this.type == null) {
            throw new EPPEncodeException("EPPEmailFwdContact type is null on call to encode");
        }
        root.setAttribute(ATTR_TYPE, this.type);
        if (this.name == null) {
            throw new EPPEncodeException("EPPEmailFwdContact name is null on call to encode");
        }
        Text textNode = aDocument.createTextNode(this.name);
        root.appendChild(textNode);
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.type = aElement.getAttribute(ATTR_TYPE);
        this.name = aElement.getFirstChild().getNodeValue();
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPEmailFwdContact)) {
            return false;
        }
        EPPEmailFwdContact theComp = (EPPEmailFwdContact)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        return this.type != null ? this.type.equals(theComp.type) : theComp.type == null;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPEmailFwdContact clone = null;
        clone = (EPPEmailFwdContact)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

