/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainAddRemove;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUpdateCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainUpdateCmd
extends EPPUpdateCmd {
    static final String ELM_NAME = "domain:update";
    private static final String ELM_DOMAIN_NAME = "domain:name";
    private String name = null;
    private EPPDomainAddRemove add = null;
    private EPPDomainAddRemove remove = null;
    private EPPDomainAddRemove change = null;

    public EPPDomainUpdateCmd() {
    }

    public EPPDomainUpdateCmd(String aName) {
        this.name = aName;
    }

    public EPPDomainUpdateCmd(String aTransId, String aName, EPPDomainAddRemove aAdd, EPPDomainAddRemove aRemove, EPPDomainAddRemove aChange) {
        super(aTransId);
        this.name = aName;
        this.setAdd(aAdd);
        this.setRemove(aRemove);
        this.setChange(aChange);
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("name required attribute is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        root.setAttribute("xmlns:domain", "urn:ietf:params:xml:ns:domain-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        if (this.add == null && this.remove == null && this.change == null) {
            this.setChange(new EPPDomainAddRemove());
            EPPUtil.encodeComp(aDocument, root, this.change);
        } else {
            EPPUtil.encodeComp(aDocument, root, this.add);
            EPPUtil.encodeComp(aDocument, root, this.remove);
            EPPUtil.encodeComp(aDocument, root, this.change);
        }
        return root;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        this.add = (EPPDomainAddRemove)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:add", EPPDomainAddRemove.class);
        if (this.add != null) {
            this.add.setMode((short)1);
        }
        this.remove = (EPPDomainAddRemove)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:rem", EPPDomainAddRemove.class);
        if (this.remove != null) {
            this.remove.setMode((short)2);
        }
        this.change = (EPPDomainAddRemove)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:chg", EPPDomainAddRemove.class);
        if (this.change != null) {
            this.change.setMode((short)3);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainUpdateCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPDomainUpdateCmd theComp = (EPPDomainUpdateCmd)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        if (!(this.add != null ? this.add.equals(theComp.add) : theComp.add == null)) {
            return false;
        }
        if (!(this.remove != null ? this.remove.equals(theComp.remove) : theComp.remove == null)) {
            return false;
        }
        return this.change != null ? this.change.equals(theComp.change) : theComp.change == null;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPDomainUpdateCmd clone = (EPPDomainUpdateCmd)super.clone();
        if (clone.add != null) {
            clone.add = (EPPDomainAddRemove)this.add.clone();
        }
        if (clone.remove != null) {
            clone.remove = (EPPDomainAddRemove)this.remove.clone();
        }
        if (clone.change != null) {
            clone.change = (EPPDomainAddRemove)this.change.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public EPPDomainAddRemove getAdd() {
        return this.add;
    }

    public void setAdd(EPPDomainAddRemove aAdd) {
        this.add = aAdd;
        if (this.add != null) {
            this.add.setMode((short)1);
        }
    }

    public EPPDomainAddRemove getRemove() {
        return this.remove;
    }

    public void setRemove(EPPDomainAddRemove aRemove) {
        this.remove = aRemove;
        if (this.remove != null) {
            this.remove.setMode((short)2);
        }
    }

    public EPPDomainAddRemove getChange() {
        return this.change;
    }

    public void setChange(EPPDomainAddRemove newChange) {
        this.change = newChange;
        if (this.change != null) {
            this.change.setMode((short)3);
        }
    }
}

