/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainRenewResp
extends EPPResponse {
    static final String ELM_NAME = "domain:renData";
    private static final String ELM_DOMAIN_NAME = "domain:name";
    private static final String ELM_EXPIRATION_DATE = "domain:exDate";
    private static final String ELM_ROID = "domain:roid";
    private String name = null;
    private Date expirationDate = null;
    private boolean cmdType = false;

    public EPPDomainRenewResp() {
    }

    public EPPDomainRenewResp(EPPTransId aTransId, String aName) {
        super(aTransId);
        this.name = aName;
    }

    public EPPDomainRenewResp(EPPTransId aTransId, String aName, Date aExpirationDate) {
        super(aTransId);
        this.name = aName;
        this.expirationDate = aExpirationDate;
    }

    public String getType() {
        return ELM_NAME;
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainRenewResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPDomainRenewResp theComp = (EPPDomainRenewResp)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        return this.expirationDate != null ? this.expirationDate.equals(theComp.expirationDate) : theComp.expirationDate == null;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPDomainRenewResp clone = (EPPDomainRenewResp)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date aExpirationDate) {
        this.expirationDate = aExpirationDate;
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPDomainRenewResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        root.setAttribute("xmlns:domain", "urn:ietf:params:xml:ns:domain-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        if (this.expirationDate != null) {
            EPPUtil.encodeTimeInstant(aDocument, root, this.expirationDate, "urn:ietf:params:xml:ns:domain-1.0", ELM_EXPIRATION_DATE);
        }
        return root;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        this.expirationDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_EXPIRATION_DATE);
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPDecodeException("Invalid state on EPPDomainRenewResp.decode: " + e);
        }
    }
}

