/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.defReg;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPDefRegName
implements EPPCodecComponent {
    public static final String LEVEL_STANDARD = "standard";
    public static final String LEVEL_PREMIUM = "premium";
    static final String ELM_NAME = "defReg:name";
    protected static final String ATTR_LEVEL = "level";
    protected String name = null;
    protected String level = null;
    private String rootName = "defReg:name";

    public EPPDefRegName() {
    }

    public EPPDefRegName(String aLevel, String aName) {
        this.level = aLevel;
        this.name = aName;
    }

    public void validate() throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("name required attribute is not set");
        }
        if (this.level == null) {
            throw new EPPEncodeException("level required attribute is not set");
        }
        if (!this.level.equals(LEVEL_STANDARD) && !this.level.equals(LEVEL_PREMIUM)) {
            throw new EPPEncodeException("Invalid level of " + this.level + " set");
        }
        if (this.level.equals(LEVEL_STANDARD)) {
            if (this.name.indexOf(".") == -1) {
                throw new EPPEncodeException("standard level should atleast contain a dot in name");
            }
        } else if (this.name.indexOf(".") != -1) {
            throw new EPPEncodeException("premium level should Not contain a dot in name");
        }
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.level = aElement.getAttribute(ATTR_LEVEL);
        this.name = aElement.getFirstChild().getNodeValue();
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validate();
        }
        catch (EPPEncodeException ex) {
            throw new EPPEncodeException("Invalid state on EPPDefRegName.encode: " + ex);
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/defReg-1.0", this.rootName);
        root.setAttribute(ATTR_LEVEL, this.level);
        Text textNode = aDocument.createTextNode(this.name);
        root.appendChild(textNode);
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDefRegName)) {
            return false;
        }
        EPPDefRegName theComp = (EPPDefRegName)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        return this.level != null ? this.level.equals(theComp.level) : theComp.level == null;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPDefRegName clone = null;
        clone = (EPPDefRegName)super.clone();
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public String getLevel() {
        return this.level;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setLevel(String aLevel) {
        this.level = aLevel;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

