/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.defReg;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EPPDefRegCheckResult
implements EPPCodecComponent {
    static final String ELM_NAME = "defReg:cd";
    private static final String ELM_DEFREG_NAME = "defReg:name";
    private static final String ELM_DEFREG_REASON = "defReg:reason";
    private static final String ATTR_AVAIL = "avail";
    private static final String ATTR_LEVEL = "level";
    private static final String ATTR_LANG = "lang";
    private static final String VALUE_LANG = "en";
    private String language = "en";
    private String name;
    private String level;
    private boolean available;
    private String reason;

    public EPPDefRegCheckResult() {
        this.name = null;
        this.level = null;
        this.available = true;
    }

    public EPPDefRegCheckResult(String aName, String aLevel, boolean aIsAvailable) {
        this.name = aName;
        this.level = aLevel;
        this.available = aIsAvailable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String aLevel) {
        this.level = aLevel;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setIsAvailable(boolean aIsAvailable) {
        this.available = aIsAvailable;
    }

    public void setDefRegReason(String aReason) {
        this.reason = aReason;
    }

    public String getDefRegReason() {
        return this.reason;
    }

    public void setLanguage(String aLang) {
        this.language = aLang;
    }

    public String getLanguage() {
        return this.language;
    }

    public void validate() throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("name required attribute is not set");
        }
        if (this.level == null) {
            throw new EPPEncodeException("level required attribute is not set");
        }
        if (!this.level.equals("standard") && !this.level.equals("premium")) {
            throw new EPPEncodeException("Invalid level of " + this.level + " set");
        }
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validate();
        }
        catch (EPPEncodeException ex) {
            throw new EPPEncodeException("Invalid state on EPPDefRegCheckResult.encode: " + ex);
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/defReg-1.0", ELM_NAME);
        Element nameElm = aDocument.createElementNS("http://www.nic.name/epp/defReg-1.0", ELM_DEFREG_NAME);
        root.appendChild(nameElm);
        nameElm.setAttribute(ATTR_LEVEL, this.level);
        EPPUtil.encodeBooleanAttr(nameElm, ATTR_AVAIL, this.available);
        Text textNode = aDocument.createTextNode(this.name);
        nameElm.appendChild(textNode);
        if (this.reason != null) {
            Element reasonElm = aDocument.createElementNS("http://www.nic.name/epp/defReg-1.0", ELM_DEFREG_REASON);
            root.appendChild(reasonElm);
            if (!this.language.equals(VALUE_LANG)) {
                reasonElm.setAttribute(ATTR_LANG, this.language);
            }
            Text aReason = aDocument.createTextNode(this.reason);
            reasonElm.appendChild(aReason);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        Element currElm = EPPUtil.getElementByTagNameNS(aElement, "http://www.nic.name/epp/defReg-1.0", ELM_DEFREG_NAME);
        this.level = currElm.getAttribute(ATTR_LEVEL);
        this.available = EPPUtil.decodeBooleanAttr(currElm, ATTR_AVAIL);
        this.name = currElm.getFirstChild().getNodeValue();
        currElm = EPPUtil.getElementByTagNameNS(aElement, "http://www.nic.name/epp/defReg-1.0", ELM_DEFREG_REASON);
        if (currElm != null) {
            this.reason = currElm.getFirstChild().getNodeValue();
            String lang = currElm.getAttribute(ATTR_LANG);
            if (lang.length() > 0 && !lang.equals(VALUE_LANG)) {
                this.setLanguage(lang);
            }
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDefRegCheckResult)) {
            return false;
        }
        EPPDefRegCheckResult theComp = (EPPDefRegCheckResult)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            return false;
        }
        return this.available == theComp.available;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPDefRegCheckResult clone = null;
        clone = (EPPDefRegCheckResult)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

