/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.contact.EPPContactDiscloseAddress;
import com.verisign.epp.codec.contact.EPPContactDiscloseName;
import com.verisign.epp.codec.contact.EPPContactDiscloseOrg;
import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPContactDisclose
implements EPPCodecComponent {
    public static final String ELM_NAME_DISCLOSE = "contact:disclose";
    private static final String ELM_CONTACT_NAME = "contact:name";
    private static final String ELM_CONTACT_ORG = "contact:org";
    private static final String ELM_CONTACT_ADDR = "contact:addr";
    private static final String ELM_CONTACT_VOICE = "contact:voice";
    private static final String ELM_CONTACT_FAX = "contact:fax";
    private static final String ELM_CONTACT_EMAIL = "contact:email";
    private static final String ATTR_FLAG = "flag";
    public static final String ATTR_FLAG_FALSE = "0";
    public static final String ATTR_FLAG_TRUE = "1";
    private static final String ATTR_TYPE = "type";
    public static final String ATTR_TYPE_LOC = "loc";
    public static final String ATTR_TYPE_INT = "int";
    private static final int MAX_NAMES = 2;
    private static final int MAX_ORGS = 2;
    private static final int MAX_ADDRS = 2;
    private String rootName = "contact:disclose";
    private String flag = "0";
    private Vector names = null;
    private Vector orgs = null;
    private Vector addresses = null;
    private String voice = null;
    private String fax = null;
    private String email = null;
    private boolean validatedFlag = true;

    public Vector getNames() {
        return this.names;
    }

    public void setNames(Vector newNames) {
        this.names = newNames;
    }

    public Vector getOrgs() {
        return this.orgs;
    }

    public void setOrgs(Vector newOrgs) {
        this.orgs = newOrgs;
    }

    public Vector getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Vector newAddresses) {
        this.addresses = newAddresses;
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String newFlag) {
        this.flag = newFlag;
    }

    public String getVoice() {
        return this.voice;
    }

    public void setVoice(String aVoice) {
        this.voice = aVoice;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String aFax) {
        this.fax = aFax;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String aEmail) {
        this.email = aEmail;
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        Object currElm = null;
        Object currVal = null;
        if (this.validatedFlag) {
            try {
                this.validateState();
            }
            catch (EPPCodecException e) {
                throw new EPPEncodeException("Invalid state on EPPContactPostalDefination.encode: " + e);
            }
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", this.rootName);
        root.setAttribute(ATTR_FLAG, this.flag);
        EPPUtil.encodeCompVector(aDocument, root, this.names);
        EPPUtil.encodeCompVector(aDocument, root, this.orgs);
        EPPUtil.encodeCompVector(aDocument, root, this.addresses);
        if (this.voice != null) {
            EPPUtil.encodeString(aDocument, root, this.voice, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
        }
        if (this.fax != null) {
            EPPUtil.encodeString(aDocument, root, this.fax, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
        }
        if (this.email != null) {
            EPPUtil.encodeString(aDocument, root, this.email, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        Object currElm = null;
        this.flag = aElement.getAttribute(ATTR_FLAG);
        this.names = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_NAME, EPPContactDiscloseName.class);
        this.orgs = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ORG, EPPContactDiscloseOrg.class);
        this.addresses = EPPUtil.decodeCompVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ADDR, EPPContactDiscloseAddress.class);
        this.voice = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_VOICE);
        this.fax = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_FAX);
        this.email = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_EMAIL);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactDisclose)) {
            return false;
        }
        EPPContactDisclose theComp = (EPPContactDisclose)aObject;
        if (!this.flag.equals(theComp.flag)) {
            return false;
        }
        if (this.names != null && !EPPUtil.equalVectors(this.names, theComp.names)) {
            return false;
        }
        if (this.orgs != null && !EPPUtil.equalVectors(this.orgs, theComp.orgs)) {
            return false;
        }
        if (this.addresses != null && !EPPUtil.equalVectors(this.addresses, theComp.addresses)) {
            return false;
        }
        if (!(this.voice != null ? this.voice.equals(theComp.voice) : theComp.voice == null)) {
            return false;
        }
        if (!(this.fax != null ? this.fax.equals(theComp.fax) : theComp.fax == null)) {
            return false;
        }
        return this.email != null ? this.email.equals(theComp.email) : theComp.email == null;
    }

    public Object clone() throws CloneNotSupportedException {
        int i;
        EPPContactDisclose clone = (EPPContactDisclose)super.clone();
        if (this.names != null) {
            clone.names = (Vector)this.names.clone();
            for (i = 0; i < this.names.size(); ++i) {
                clone.names.setElementAt(((EPPContactDiscloseName)this.names.elementAt(i)).clone(), i);
            }
        }
        if (this.orgs != null) {
            clone.orgs = (Vector)this.orgs.clone();
            for (i = 0; i < this.orgs.size(); ++i) {
                clone.orgs.setElementAt(((EPPContactDiscloseOrg)this.orgs.elementAt(i)).clone(), i);
            }
        }
        if (this.addresses != null) {
            clone.addresses = (Vector)this.addresses.clone();
            for (i = 0; i < this.addresses.size(); ++i) {
                clone.addresses.setElementAt(((EPPContactDiscloseAddress)this.addresses.elementAt(i)).clone(), i);
            }
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    protected void validateState() throws EPPCodecException {
        boolean bFound = false;
        if (this.rootName == null) {
            throw new EPPCodecException("root element name is not set");
        }
        if (!this.rootName.equals(ELM_NAME_DISCLOSE)) {
            throw new EPPCodecException("root element name is not recognized");
        }
        if (this.names != null && this.names.elements().hasMoreElements()) {
            bFound = true;
            if (this.names.size() > 2) {
                throw new EPPCodecException("name lines exceed the maximum");
            }
        }
        if (this.orgs != null && this.orgs.elements().hasMoreElements()) {
            bFound = true;
            if (this.orgs.size() > 2) {
                throw new EPPCodecException("org lines exceed the maximum");
            }
        }
        if (this.addresses != null && this.addresses.elements().hasMoreElements()) {
            bFound = true;
            if (this.addresses.size() > 2) {
                throw new EPPCodecException("address lines exceed the maximum");
            }
        }
        if (this.voice != null || this.fax != null || this.email != null) {
            bFound = true;
        }
        if (!bFound) {
            throw new EPPCodecException("disclose element is empty");
        }
    }

    public String getRootName() {
        return this.rootName;
    }

    public void setRootName(String newRootName) {
        this.rootName = newRootName;
    }

    public boolean isValidated() {
        return this.validatedFlag;
    }

    public void setValidatedFlag(boolean newValidatedFlag) {
        this.validatedFlag = newValidatedFlag;
    }
}

