/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.gen.EPPCheckCmd;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPContactCheckCmd
extends EPPCheckCmd {
    static final String ELM_NAME = "contact:check";
    private static final String ELM_CONTACT_NAME = "contact:id";
    private Vector ids;

    public EPPContactCheckCmd() {
        this.ids = new Vector();
    }

    public EPPContactCheckCmd(String aTransId, String aId) {
        super(aTransId);
        this.ids = new Vector();
        this.ids.addElement(aId);
    }

    public EPPContactCheckCmd(String aTransId, Vector someIds) {
        super(aTransId);
        this.ids = someIds;
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.ids.size() == 0) {
            throw new EPPEncodeException("No contact ids specified in EPPContactCheckCmd");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        root.setAttribute("xmlns:contact", "urn:ietf:params:xml:ns:contact-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:contact-1.0 contact-1.0.xsd");
        EPPUtil.encodeVector(aDocument, root, this.ids, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_NAME);
        return root;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.ids = EPPUtil.decodeVector(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_NAME);
        if (this.ids == null) {
            this.ids = new Vector();
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactCheckCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPContactCheckCmd theComp = (EPPContactCheckCmd)aObject;
        return EPPUtil.equalVectors(this.ids, theComp.ids);
    }

    public Object clone() throws CloneNotSupportedException {
        EPPContactCheckCmd clone = (EPPContactCheckCmd)super.clone();
        clone.ids = (Vector)this.ids.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public void setId(String aId) {
        this.ids = new Vector();
        this.ids.addElement(aId);
    }

    public Vector getIds() {
        return this.ids;
    }

    public void setIds(Vector someIds) {
        this.ids = someIds;
    }
}

