/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.balance;

import com.verisign.epp.codec.balance.EPPCreditThreshold;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPBalanceInfoResp
extends EPPResponse {
    private static Logger cat = Logger.getLogger((String)EPPBalanceInfoResp.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_NAME = "balance:infData";
    public static final String ELM_CREDIT_LIMIT = "balance:creditLimit";
    public static final String ELM_BALANCE = "balance:balance";
    public static final String ELM_AVAILABLE_CREDIT = "balance:availableCredit";
    private BigDecimal creditLimit;
    private BigDecimal balance;
    private BigDecimal availableCredit;
    private EPPCreditThreshold creditThreshold;

    public EPPBalanceInfoResp() {
    }

    public EPPBalanceInfoResp(EPPTransId aTransId, BigDecimal aCreditLimit, BigDecimal aBalance, BigDecimal aAvailableCredit, EPPCreditThreshold aCreditThreshold) {
        super(aTransId);
        this.creditLimit = aCreditLimit;
        this.balance = aBalance;
        this.availableCredit = aAvailableCredit;
        this.creditThreshold = aCreditThreshold;
    }

    public Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPBalanceInfoResponse.doEncode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPBalanceInfoResponse invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPBalanceInfoResponse.doEncode(Document)");
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/balance-1.0", ELM_NAME);
        root.setAttribute("xmlns:balance", "http://www.verisign.com/epp/balance-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.verisign.com/epp/balance-1.0 balance-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.creditLimit.toString(), "http://www.verisign.com/epp/balance-1.0", ELM_CREDIT_LIMIT);
        EPPUtil.encodeString(aDocument, root, this.balance.toString(), "http://www.verisign.com/epp/balance-1.0", ELM_BALANCE);
        EPPUtil.encodeString(aDocument, root, this.availableCredit.toString(), "http://www.verisign.com/epp/balance-1.0", ELM_AVAILABLE_CREDIT);
        EPPUtil.encodeComp(aDocument, root, this.creditThreshold);
        return root;
    }

    public void doDecode(Element aElement) throws EPPDecodeException {
        this.creditLimit = new BigDecimal(EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/balance-1.0", ELM_CREDIT_LIMIT));
        this.balance = new BigDecimal(EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/balance-1.0", ELM_BALANCE));
        this.availableCredit = new BigDecimal(EPPUtil.decodeString(aElement, "http://www.verisign.com/epp/balance-1.0", ELM_AVAILABLE_CREDIT));
        this.creditThreshold = (EPPCreditThreshold)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/balance-1.0", "balance:creditThreshold", EPPCreditThreshold.class);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPBalanceInfoResp)) {
            cat.error((Object)("EPPBalanceInfoResp.equals(): " + aObject.getClass().getName() + " not EPPBalanceInfoResp instance"));
            return false;
        }
        EPPBalanceInfoResp theComp = (EPPBalanceInfoResp)aObject;
        if (!(this.creditLimit != null ? this.creditLimit.equals(theComp.creditLimit) : theComp.creditLimit == null)) {
            cat.error((Object)"EPPBalanceInfoResp.equals(): creditLimit not equal");
            return false;
        }
        if (!(this.balance != null ? this.balance.equals(theComp.balance) : theComp.balance == null)) {
            cat.error((Object)"EPPBalanceInfoResp.equals(): balance not equal");
            return false;
        }
        if (!(this.availableCredit != null ? this.availableCredit.equals(theComp.availableCredit) : theComp.availableCredit == null)) {
            cat.error((Object)"EPPBalanceInfoResp.equals(): availableCredit not equal");
            return false;
        }
        if (!(this.creditThreshold != null ? this.creditThreshold.equals(theComp.creditThreshold) : theComp.creditThreshold == null)) {
            cat.error((Object)"EPPBalanceInfoResp.equals(): creditThreshold not equal");
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPBalanceInfoResp clone = (EPPBalanceInfoResp)super.clone();
        clone.creditLimit = this.creditLimit != null ? new BigDecimal(this.creditLimit.toString()) : null;
        clone.balance = this.balance != null ? new BigDecimal(this.balance.toString()) : null;
        clone.availableCredit = this.availableCredit != null ? new BigDecimal(this.availableCredit.toString()) : null;
        clone.creditThreshold = this.creditThreshold != null ? (EPPCreditThreshold)this.creditThreshold.clone() : null;
        return clone;
    }

    void validateState() throws EPPCodecException {
        if (this.creditLimit == null) {
            throw new EPPCodecException("EPPBalanceInfoResp required creditLimit attribute is not set");
        }
        if (this.balance == null) {
            throw new EPPCodecException("EPPBalanceInfoResp required balance attribute is not set");
        }
        if (this.availableCredit == null) {
            throw new EPPCodecException("EPPBalanceInfoResp required availableCredit attribute is not set");
        }
        if (this.creditThreshold == null) {
            throw new EPPCodecException("EPPBalanceInfoResp required creditThreshold attribute is not set");
        }
    }

    public BigDecimal getCreditLimit() {
        return this.creditLimit;
    }

    public void setCreditLimit(BigDecimal aCreditLimit) {
        this.creditLimit = aCreditLimit;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal aBalance) {
        this.balance = aBalance;
    }

    public BigDecimal getAvailableCredit() {
        return this.availableCredit;
    }

    public void setAvailableCredit(BigDecimal aAvailableCredit) {
        this.availableCredit = aAvailableCredit;
    }

    public EPPCreditThreshold getCreditThreshold() {
        return this.creditThreshold;
    }

    public void setCreditThreshold(EPPCreditThreshold aCreditThreshold) {
        this.creditThreshold = aCreditThreshold;
    }
}

