/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.util;

import com.codestudio.util.GenericPool;
import com.codestudio.util.GenericPoolManager;
import com.codestudio.util.GenericPoolMetaData;
import com.codestudio.util.ObjectPool;
import com.codestudio.util.PoolMetaData;
import com.verisign.epp.util.EPPSchemaCachingParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLParserTst
extends TestCase {
    private static final String TEST_DIR = System.getProperty("eppsdk.gen.xml.dir");
    private static final String ITERATIONS = System.getProperty("eppsdk.gen.xml.test.iterations");
    private static final String THREADS = System.getProperty("eppsdk.gen.xml.test.threads");
    private static final String PARSER_IMPL = System.getProperty("eppsdk.gen.xml.test.parserImpl");
    private static final String SYMBOL_TABLE_SIZE = System.getProperty("eppsdk.gen.xml.test.symbolTableSize");
    public static final String POOL_NAME = "com.verisign.epp.codec.gen.XMLParserTst";
    public static final int NUM_PARSERS_IN_POOL = 10;
    private String testFile = null;

    public XMLParserTst(String name, String aXmlFile) {
        super(name);
        this.testFile = aXmlFile;
    }

    public static void printResults(PrintWriter out, String uri, long time, boolean tagginess, int repetition) {
        out.print(uri);
        out.print(": ");
        if (repetition == 1) {
            out.print(time);
        } else {
            out.print(time);
            out.print('/');
            out.print(repetition);
            out.print('=');
            out.print((float)time / (float)repetition);
        }
        out.print(" ms");
        out.println();
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTurnOffValidation() {
        String xmlInstance = this.getFileContents(this.testFile);
        byte[] bytesToParse = xmlInstance.getBytes();
        EPPSchemaCachingParser parser = null;
        try {
            parser = (EPPSchemaCachingParser)GenericPoolManager.getInstance().getPool(POOL_NAME).requestObject();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            Assert.assertEquals((boolean)false, (boolean)parser.isValidating());
            Document doc = null;
            doc = parser.parse(new InputSource(new ByteArrayInputStream(bytesToParse)));
            Assert.assertNotNull((Object)doc);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            GenericPoolManager.getInstance().getPool(POOL_NAME).returnObject((Object)parser);
        }
    }

    public void testParsing() {
        String xmlInstance = this.getFileContents(this.testFile);
        ArrayList<RunnerThread> threadArray = new ArrayList<RunnerThread>();
        long startTime = System.currentTimeMillis();
        long memoryBefore = Runtime.getRuntime().freeMemory();
        for (int i = 0; i < Integer.parseInt(THREADS); ++i) {
            RunnerThread runner = new RunnerThread(Integer.parseInt(ITERATIONS), xmlInstance);
            threadArray.add(runner);
            runner.start();
        }
        try {
            for (int j = 0; j < threadArray.size(); ++j) {
                Thread runningThread = (Thread)threadArray.get(j);
                runningThread.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long finishTime = System.currentTimeMillis();
        long totalTime = finishTime - startTime;
        System.out.println("Total time was: " + totalTime);
        long memoryAfter = Runtime.getRuntime().freeMemory();
        long memory = memoryBefore - memoryAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetSymbolTableSize() {
        String xmlInstance = this.getFileContents(this.testFile);
        byte[] bytesToParse = xmlInstance.getBytes();
        EPPSchemaCachingParser parser = null;
        try {
            parser = (EPPSchemaCachingParser)GenericPoolManager.getInstance().getPool(POOL_NAME).requestObject();
            parser.setSymbolTableSize(1299709);
            Document doc = null;
            doc = parser.parse(new InputSource(new ByteArrayInputStream(bytesToParse)));
            Assert.assertNotNull((Object)doc);
            parser.setSymbolTableSize(2039);
            doc = parser.parse(new InputSource(new ByteArrayInputStream(bytesToParse)));
            Assert.assertNotNull((Object)doc);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            GenericPoolManager.getInstance().getPool(POOL_NAME).returnObject((Object)parser);
        }
    }

    public void testSetNoSymbolTableSize() {
    }

    public void testLockSchemaCache() {
    }

    public void testSchemaNotFoundInClasspath() {
    }

    public void testDomParser() {
        String xmlInstance = this.getFileContents(this.testFile);
        byte[] bytesToParse = xmlInstance.getBytes();
        DOMParser domParser = new DOMParser();
        Document doc = null;
        try {
            domParser.setFeature("http://xml.org/sax/features/validation", false);
            domParser.parse(new InputSource(new ByteArrayInputStream(bytesToParse)));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        doc = domParser.getDocument();
        Assert.assertNotNull((Object)doc);
    }

    public static Test suite() {
        System.out.println("suite");
        TestSuite suite = new TestSuite();
        String testFile = System.getProperty("eppsdk.gen.xml.instance");
        if (testFile == null) {
            testFile = File.separator + "login.xml";
            System.out.println("No testfile XML instance specified.  This can set by setting the eppsdk.gen.xml.instance System property. Using default: " + testFile);
        }
        System.out.println("Using XML instance file: " + testFile);
        suite.addTest((Test)new XMLParserTst("testParsing", TEST_DIR + File.separator + testFile));
        suite.addTest((Test)new XMLParserTst("testTurnOffValidation", TEST_DIR + File.separator + testFile));
        suite.addTest((Test)new XMLParserTst("testDomParser", TEST_DIR + File.separator + testFile));
        suite.addTest((Test)new XMLParserTst("testSetSymbolTableSize", TEST_DIR + File.separator + testFile));
        return suite;
    }

    public String getFileContents(String aFilename) {
        StringBuffer commandBuffer = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(new FileReader(aFilename));
            String nextLine = null;
            while ((nextLine = br.readLine()) != null) {
                commandBuffer.append(nextLine);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return commandBuffer.toString();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.initParserPool();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        GenericPoolManager.getInstance().removePool(POOL_NAME);
    }

    private void initParserPool() {
        GenericPoolMetaData meta = new GenericPoolMetaData();
        meta.setName(POOL_NAME);
        meta.setObjectType(PARSER_IMPL);
        meta.setInitialObjects(10);
        meta.setMinimumSize(10);
        meta.setMaximumSize(10);
        meta.setUserTimeout(0);
        meta.setDebugging(false);
        GenericPool newPool = new GenericPool((PoolMetaData)meta);
        GenericPoolManager.getInstance().addPool(POOL_NAME, (ObjectPool)newPool);
    }

    class RunnerThread
    extends Thread {
        int iterations = 1;
        String xmlInstance = null;

        RunnerThread(int aIterations, String aXmlInstance) {
            this.iterations = aIterations;
            this.xmlInstance = aXmlInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            System.out.println("Thread " + this.getName() + " started");
            System.out.println(this.getName() + " executing " + this.iterations + " iterations");
            byte[] bytesToParse = this.xmlInstance.getBytes();
            long timeBefore = System.currentTimeMillis();
            long memoryBefore = Runtime.getRuntime().freeMemory();
            DocumentBuilder parser = null;
            Document doc = null;
            try {
                parser = (DocumentBuilder)GenericPoolManager.getInstance().getPool(XMLParserTst.POOL_NAME).requestObject();
                for (int i = 0; i < this.iterations; ++i) {
                    InputSource inSource = new InputSource(new ByteArrayInputStream(bytesToParse));
                    doc = parser.parse(inSource);
                    Assert.assertNotNull((Object)doc);
                }
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                GenericPoolManager.getInstance().getPool(XMLParserTst.POOL_NAME).returnObject((Object)parser);
            }
            long timeAfter = System.currentTimeMillis();
            long time = timeAfter - timeBefore;
            XMLParserTst.printResults(new PrintWriter(System.out), this.getName(), time, false, this.iterations);
        }
    }
}

