/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.interfaces;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.suggestion.EPPSuggestionInfoResp;
import com.verisign.epp.interfaces.EPPCommandException;
import com.verisign.epp.interfaces.EPPSession;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPPSuggestion {
    private EPPCommand command = null;
    private Vector<EPPCodecComponent> extensions = null;
    private EPPResponse response = null;
    private EPPSession session = null;

    public EPPSuggestion(EPPSession newSession) {
        this.session = newSession;
    }

    public void addExtension(EPPCodecComponent aExtension) {
        if (this.extensions == null) {
            this.extensions = new Vector();
        }
        this.extensions.addElement(aExtension);
    }

    public EPPCommand getCommand() {
        return this.command;
    }

    public Vector<EPPCodecComponent> getExtensions() {
        return this.extensions;
    }

    public EPPResponse getResponse() {
        return this.response;
    }

    public EPPSession getSession() {
        return this.session;
    }

    private void resetSuggestion() {
        this.command = null;
        this.extensions = null;
    }

    public EPPSuggestionInfoResp sendInfo() throws EPPCommandException {
        this.command.setExtensions(this.extensions);
        this.response = this.session.processDocument(this.command);
        if (!(this.response instanceof EPPSuggestionInfoResp)) {
            throw new EPPCommandException("Unexpected response type of " + this.response.getClass().getName() + ", expecting " + EPPSuggestionInfoResp.class.getName());
        }
        this.resetSuggestion();
        return (EPPSuggestionInfoResp)this.response;
    }

    public void setCommand(EPPCommand command) {
        this.command = command;
    }

    public void setExtensions(Vector<EPPCodecComponent> aExtensions) {
        this.extensions = aExtensions;
    }

    public void setSession(EPPSession aSession) {
        this.session = aSession;
    }
}

