/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryContactCity;
import com.verisign.epp.codec.registry.EPPRegistryContactPostalCode;
import com.verisign.epp.codec.registry.EPPRegistryContactStateProvince;
import com.verisign.epp.codec.registry.EPPRegistryContactStreet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryContactAddress
implements EPPCodecComponent {
    private static final long serialVersionUID = -8821366021541599063L;
    public static final String ELM_NAME = "registry:address";
    public static final String ELM_COUNTRY_CODE = "registry:defaultCC";
    private EPPRegistryContactStreet street = null;
    private EPPRegistryContactCity city = null;
    private EPPRegistryContactStateProvince stateProvince = null;
    private EPPRegistryContactPostalCode postalCode = null;

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryContactAddress.encode: " + e);
        }
        Element aRoot = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        EPPUtil.encodeComp(aDocument, aRoot, this.street);
        EPPUtil.encodeComp(aDocument, aRoot, this.city);
        EPPUtil.encodeComp(aDocument, aRoot, this.stateProvince);
        EPPUtil.encodeComp(aDocument, aRoot, this.postalCode);
        return aRoot;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.setStreet((EPPRegistryContactStreet)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:street", EPPRegistryContactStreet.class));
        this.setCity((EPPRegistryContactCity)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:city", EPPRegistryContactCity.class));
        this.setStateProvince((EPPRegistryContactStateProvince)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:sp", EPPRegistryContactStateProvince.class));
        this.setPostalCode((EPPRegistryContactPostalCode)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:pc", EPPRegistryContactPostalCode.class));
    }

    void validateState() throws EPPCodecException {
        if (this.street == null) {
            throw new EPPCodecException("street required element is not set");
        }
        if (this.city == null) {
            throw new EPPCodecException("city required element is not set");
        }
        if (this.stateProvince == null) {
            throw new EPPCodecException("stateProvince required element is not set");
        }
        if (this.postalCode == null) {
            throw new EPPCodecException("postalCode required element is not set");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRegistryContactAddress clone = (EPPRegistryContactAddress)super.clone();
        if (this.street != null) {
            clone.street = (EPPRegistryContactStreet)this.street.clone();
        }
        if (this.city != null) {
            clone.city = (EPPRegistryContactCity)this.city.clone();
        }
        if (this.stateProvince != null) {
            clone.stateProvince = (EPPRegistryContactStateProvince)this.stateProvince.clone();
        }
        if (this.postalCode != null) {
            clone.postalCode = (EPPRegistryContactPostalCode)this.postalCode.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryContactAddress)) {
            return false;
        }
        EPPRegistryContactAddress theComp = (EPPRegistryContactAddress)aObject;
        if (!(this.street != null ? this.street.equals(theComp.street) : theComp.street == null)) {
            return false;
        }
        if (!(this.city != null ? this.city.equals(theComp.city) : theComp.city == null)) {
            return false;
        }
        if (!(this.stateProvince != null ? this.stateProvince.equals(theComp.stateProvince) : theComp.stateProvince == null)) {
            return false;
        }
        return this.postalCode != null ? this.postalCode.equals(theComp.postalCode) : theComp.postalCode == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryContactCity getCity() {
        return this.city;
    }

    public void setCity(EPPRegistryContactCity city) {
        this.city = city;
    }

    public EPPRegistryContactStateProvince getStateProvince() {
        return this.stateProvince;
    }

    public void setStateProvince(EPPRegistryContactStateProvince stateProvince) {
        this.stateProvince = stateProvince;
    }

    public EPPRegistryContactPostalCode getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(EPPRegistryContactPostalCode postalCode) {
        this.postalCode = postalCode;
    }

    public EPPRegistryContactStreet getStreet() {
        return this.street;
    }

    public void setStreet(EPPRegistryContactStreet street) {
        this.street = street;
    }
}

