/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.domain;

import com.verisign.epp.codec.domain.EPPDomainPeriod;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPTransferCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPDomainTransferCmd
extends EPPTransferCmd {
    static final String ELM_NAME = "domain:transfer";
    private static final String ELM_DOMAIN_NAME = "domain:name";
    private String name = null;
    private EPPDomainPeriod period = null;
    private EPPAuthInfo authInfo = null;

    public EPPDomainTransferCmd() {
        this.name = null;
        this.period = null;
        this.authInfo = null;
    }

    public EPPDomainTransferCmd(String aTransId, String aOp, String aName) {
        super(aTransId, aOp);
        this.name = aName;
    }

    public EPPDomainTransferCmd(String aTransId, String aOp, String aName, EPPAuthInfo aAuthInfo, EPPDomainPeriod aPeriod) {
        super(aTransId, aOp);
        this.name = aName;
        this.period = aPeriod;
        this.setAuthInfo(aAuthInfo);
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:domain-1.0";
    }

    void validateState() throws EPPCodecException {
        if (super.getOp() == null) {
            throw new EPPCodecException("op required attribute is not set");
        }
        if (this.name == null) {
            throw new EPPCodecException("name required attribute is not set");
        }
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("EPPDomainTransferCmd invalid state: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:domain-1.0", ELM_NAME);
        root.setAttribute("xmlns:domain", "urn:ietf:params:xml:ns:domain-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:domain-1.0 domain-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        if (this.period != null && !this.period.isPeriodUnspec()) {
            EPPUtil.encodeComp(aDocument, root, this.period);
        }
        EPPUtil.encodeComp(aDocument, root, this.authInfo);
        return root;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:domain-1.0", ELM_DOMAIN_NAME);
        this.period = (EPPDomainPeriod)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:period", EPPDomainPeriod.class);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo", EPPAuthInfo.class);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPDomainTransferCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPDomainTransferCmd theMap = (EPPDomainTransferCmd)aObject;
        if (!(this.name != null ? this.name.equals(theMap.name) : theMap.name == null)) {
            return false;
        }
        if (!(this.period != null ? this.period.equals(theMap.period) : theMap.period == null)) {
            return false;
        }
        return this.authInfo != null ? this.authInfo.equals(theMap.authInfo) : theMap.authInfo == null;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPDomainTransferCmd clone = (EPPDomainTransferCmd)super.clone();
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        if (this.period != null) {
            clone.period = (EPPDomainPeriod)this.period.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public EPPDomainPeriod getPeriod() {
        return this.period;
    }

    public void setAuthInfo(EPPAuthInfo newAuthInfo) {
        if (newAuthInfo != null) {
            this.authInfo = newAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:domain-1.0", "domain:authInfo");
        }
    }

    public void setPeriod(EPPDomainPeriod aPeriod) {
        this.period = aPeriod;
    }
}

