/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.contact;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPInfoCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPContactInfoCmd
extends EPPInfoCmd {
    static final String ELM_NAME = "contact:info";
    private static final String ELM_CONTACT_ID = "contact:id";
    private String id;
    private EPPAuthInfo authInfo = null;

    public EPPContactInfoCmd() {
        this.id = null;
    }

    public EPPContactInfoCmd(String aTransId, String aId) {
        super(aTransId);
        this.id = aId;
    }

    public EPPContactInfoCmd(String aTransId, String aName, EPPAuthInfo aAuthInfo) {
        this(aTransId, aName);
        this.authInfo = aAuthInfo;
        this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", "contact:authInfo");
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:contact-1.0";
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.id == null) {
            throw new EPPEncodeException("required attribute id is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:contact-1.0", ELM_NAME);
        root.setAttribute("xmlns:contact", "urn:ietf:params:xml:ns:contact-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:contact-1.0 contact-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.id, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        if (this.authInfo != null) {
            EPPUtil.encodeComp(aDocument, root, this.authInfo);
        }
        return root;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.id = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:contact-1.0", ELM_CONTACT_ID);
        this.authInfo = (EPPAuthInfo)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:contact-1.0", "contact:authInfo", EPPAuthInfo.class);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String aId) {
        this.id = aId;
    }

    public EPPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(EPPAuthInfo aAuthInfo) {
        if (aAuthInfo != null) {
            this.authInfo = aAuthInfo;
            this.authInfo.setRootName("urn:ietf:params:xml:ns:contact-1.0", "contact:authInfo");
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPContactInfoCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPContactInfoCmd theComp = (EPPContactInfoCmd)aObject;
        if (!(this.id != null ? this.id.equals(theComp.id) : theComp.id == null)) {
            return false;
        }
        return this.authInfo != null ? this.authInfo.equals(theComp.authInfo) : theComp.authInfo == null;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPContactInfoCmd clone = (EPPContactInfoCmd)super.clone();
        if (this.authInfo != null) {
            clone.authInfo = (EPPAuthInfo)this.authInfo.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

