/***********************************************************
Copyright (C) 2023 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.host.EPPHostCreateCmd;
import com.verisign.epp.codec.host.EPPHostInfoCmd;
import com.verisign.epp.codec.host.EPPHostUpdateCmd;

/**
 * Sub Host Handler for use with the TTL extension.  
 * This interface is used to support handling multiple versions of the 
 * TTL extension, where each different version of the 
 * TTL extension must implement this interface.  
 */
public interface TtlSubHostHandler {
    
  
  /**
   * Handle an EPP Host Info Command.  
   * 
   * @param aInfoCommand Command sent by the client
   * @param aResponse Response created previously up the stack
   * @param aData Server data.  This is assumed to be an instance of {@code SessionData}.
   */
  void doHostInfo(EPPHostInfoCmd aInfoCommand, EPPResponse aResponse, Object aData);
  
  
  /**
   * Handle an EPP Host Create Command.  
   * 
   * @param aCreateCommand Command sent by the client
   * @param aResponse Response created previously up the stack
   * @param aData Server data.  This is assumed to be an instance of {@code SessionData}.
   */
  void doHostCreate(EPPHostCreateCmd aCreateCommand, EPPResponse aResponse, Object aData);
      
  /**
   * Handle an EPP Host Update Command.  
   * 
   * @param aUpdateCommand Command sent by the client
   * @param aResponse Response created previously up the stack
   * @param aData Server data.  This is assumed to be an instance of {@code SessionData}.
   */
  void doHostUpdate(EPPHostUpdateCmd aUpdateCommand, EPPResponse aResponse, Object aData);  
}
