/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/
package com.verisign.epp.framework;

import java.util.List;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.registry.policy.EPPRegistryZoneInterface;

/**
 * {@code EPPRegistryPolicyAdapter} is a base class used to adapt zone or system
 * policy extensions from local server classes to / from EPP extensions. The
 * methods of {@code EPPRegistryPolicyAdapter} are concrete and return
 * {@code null} by default. A derived class can support either a zone or system
 * policy extension by overriding the appropriate methods.
 */
public class EPPRegistryPolicyAdapter {

  /**
   * Adapt a list of EPP extensions used with a registry create or update to a
   * matching zone policy extension. It is assumed that there will be an
   * {@code EPPRegistryPolicyAdapter} for each versioned policy extension that
   * will be used to extract the contained zone policy information in a
   * matching EPP extension.
   * 
   * @param aEppExtensions
   *           List of EPP extensions to adapt to a zone policy extension.
   * 
   * @return Matching zone policy extension if found; {@code null} otherwise.
   */
  public EPPRegistryZoneInterface eppExtToZoneExt(List<EPPCodecComponent> aEppExtensions) {
    return null;
  }

  /**
   * Adapt a list of zone policy extensions available for the zone to a
   * matching EPP extension for an info response.
   * 
   * @param aZoneExtensions
   *           List of zone policy extensions to adapt to an EPP extension for
   *           an info response.
   * @return Matching EPP extension for an info response if found; {@code null}
   *         otherwise.
   */
  public EPPCodecComponent zoneExtToEppExt(List<EPPRegistryZoneInterface> aZoneExtensions) {
    return null;
  }

  /**
   * Gets the system policy extension to include in a registry info response
   * for the system.
   * 
   * @return {@link EPPCodecComponent} that represents the system policy
   *         extension if defined; {@code null} otherwise.
   */
  public EPPCodecComponent getSystemExt() {
    return null;
  }

}
