/***********************************************************
Copyright (C) 2024 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.transport.server;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.verisign.epp.transport.ServerEventHandler;

import net.luminis.quic.QuicStream;

/**
 * Server thread for processing a new client connection and to loop process
 * commands.
 */
public class EPPQuicServerThread extends Thread {
	/** Category for logging */
	private static Logger cat = LoggerFactory.getLogger(EPPQuicServerThread.class);

	/**
	 * Quic stream being used by thread
	 */
	private QuicStream quicStream;

	/**
	 * Client connection handler
	 */
	private ServerEventHandler handler = null;

	/**
	 * Creates a new EPPQuicServerThread object.
	 *
	 * @param aStream
	 *           Quick stream to handle in thread
	 * @param aHandler
	 *           Client connection handler
	 */
	public EPPQuicServerThread(QuicStream aStream, ServerEventHandler aHandler) {
		super("EPPMultiServerThread");
		this.quicStream = aStream;
		this.handler = aHandler;
	}

	/**
	 * Process the client connection.
	 */
	@Override
	public void run() {
		cat.info("run(): enter");

		if (this.handler == null) {
			cat.error("The Server Handler is not Set");
			return;
		}

		try {
			ServerEventHandler theServerEventHandler = (ServerEventHandler) this.handler.clone();
			theServerEventHandler.handleConnection(this.quicStream.getInputStream(), this.quicStream.getOutputStream());
		}
		catch (CloneNotSupportedException ex) {
			cat.error("Server Run : CloneNotSupportedException : " + ex.getMessage(), ex);
			return;
		}

		cat.info("run(): exit");
	}
}
