/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/
package com.verisign.epp.serverstub;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.verisign.epp.codec.gen.EPPLoginCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.serverstub.v1_0.LoginSecV1_0GenHandler;


/**
 * The <code>LoginSecGenHandler</code> class is an extension of the
 * {@link GenHandler} to override the login command based on one of the
 * supported login security extension versions. It handles accepting commands in
 * a server that supports more than one version of the login security extension.
 * The version specific <code>LoginSecSubGenHandler</code> is called based on
 * the login security extension version passed.
 *
 * @see com.verisign.epp.framework.EPPEvent
 * @see com.verisign.epp.framework.EPPEventResponse
 */
public class LoginSecGenHandler extends GenHandler {

  /** Used for logging */
      private static Logger cat = LoggerFactory.getLogger(LoginSecGenHandler.class);
        

  // Sub-handler for handling version 1.0 extension messages.
  LoginSecV1_0GenHandler v1_0SubHandler = new LoginSecV1_0GenHandler();

  /**
   * Handle a login command by routing commands with the login security
   * extension to the appropriate version of handler; otherwise send to the
   * base handler.
   *
   * @param aEvent
   *           Event must contain an {@link EPPLoginCmd} for handling
   * @param aData
   *           Extra server data, which is <code>SessionData</code> for the
   *           Stub Server.
   *
   * @return Response to handling the login command
   */
  protected EPPEventResponse doLogin(EPPEvent aEvent, Object aData) {
    SessionData theSessionData = (SessionData) aData;
    EPPLoginCmd theCommand = (EPPLoginCmd) aEvent.getMessage();

    // v1_0 of login security extension?
    if (theCommand.hasExtension(com.verisign.epp.codec.loginsec.v1_0.EPPLoginSec.class)) {
      return this.v1_0SubHandler.doLogin(aEvent, aData);
    } // v04 of login security extension?
    else {
      // v1_0 of login security extension supported?
      if (theCommand.hasExtensionService(com.verisign.epp.codec.loginsec.v1_0.EPPLoginSecExtFactory.NS)) {
        return this.v1_0SubHandler.doLogin(aEvent, aData);
      } // v04 of login security extension supported?
      else {
        cat.info("doLogin: No login security extension, executing default handler");
        return super.doLogin(aEvent, aData);

      }

    }

  }

}
