/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;

import org.w3c.dom.Document;

import com.verisign.epp.exception.EPPException;
import com.verisign.epp.transport.EPPClientCon;
import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.EPPConFactorySingle;

/**
 * This Class provides a unit test for EPPXMLStream
 */
public class EPPXMLStreamTst {
	/**
	 * Test main method
	 *
	 * @param args
	 *           Command line arguments
	 */
	public static void main(String[] args) {
		String myString = null;

		EPPXMLStreamTst myInstance = new EPPXMLStreamTst();

		Socket socket = null;
		InputStream inputStream = null;
		OutputStream outputStream = null;
		Document doc = null;
		EPPXMLStream stream = null;
		EPPClientCon connection = null;

		/** Initialize the Env */
		EPPEnvSingle env = EPPEnvSingle.getInstance();

		/**
		 * initialize the Environment
		 */
		try {
			env.initialize("epp.config");
		}
		catch (EPPEnvException e) {
			System.out.println("EPPEvnException is thrown :" + e.getMessage());

			return;
		}


		/** Get the Client Connection from factory */
		EPPConFactorySingle myCon = EPPConFactorySingle.getInstance();

		/**
		 * instantiate this Class.
		 */
		stream = new EPPXMLStream();

		/**
		 * Connect to the Server
		 */
		try {
			connection = myCon.getEPPConnection();
		}
		catch (EPPConException myException) {
			System.out.println("EPPApplication.initialze():  " + myException.getMessage());

			return;
		}

		try {
			connection.initialize();
		}
		catch (EPPConException myException) {
			System.out.println("EPPApplication.initialze():  " + myException.getMessage());

			return;
		}

		/**
		 * Set up the Connection
		 */
		try {
			inputStream = connection.getInputStream();
			outputStream = connection.getOutputStream();
		}
		catch (EPPConException myException) {
			System.out.println("EPPConException When getting Streams" + myException.getMessage());

			return;
		}

		/**
		 * Parse the Document
		 */
		try {
			boolean theDocFound = false;
			while (!theDocFound) {
				try {
					doc = stream.read(inputStream);
					theDocFound = true;
				}
				catch (InterruptedIOException ex) {
					System.out.println("InterruptedIOException, continueing to read: " + ex.getMessage());
				}
			}
		}
		catch (EPPException myException) {
			System.out.println("EPPException: " + myException.getMessage());

			return;
		}
		catch (IOException e) {
			System.out.println("IOException: " + e.getMessage());

			return;
		}

		/**
		 * Write a Dom Document
		 */
		try {
			stream.write(doc, outputStream, null);
		}
		catch (EPPException myException) {
			System.out.println("Exception " + myException.getMessage());

			return;
		}

		/**
		 * Finished so close everything and exit
		 */
		try {
			inputStream.close();
			outputStream.close();
			connection.close();
		}
		catch (EPPConException myException) {
			System.out.println("EPPApplication.endApplication() : " + myException.getMessage());

			return;
		}
		catch (IOException myException) {
			System.out.println("Exception " + myException.getMessage());

			return;
		}
	}
}
