/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.codec.gen;

import org.w3c.dom.Element;

/**
 * {@code EPPTestGenMapFactory} is a test map factory used to test the
 * general (gen) EPP package. The fully qualified class name for
 * {@code EPPTestGenMapFactory} is included in a call to
 * {@code EPPFactory.init} or {@code EPPCodec.init}. <br>
 * <br>
 *
 * @see com.verisign.epp.codec.gen.EPPCodec
 * @see com.verisign.epp.codec.gen.EPPFactory
 * @see com.verisign.epp.codec.gen.EPPCommand
 * @see com.verisign.epp.codec.gen.EPPResponse
 */
public class EPPTestGenMapFactory extends EPPMapFactory {

  /** Namespace URI associated with EPPTestGenMapFactory. */
  public static final String NS = "http://www.verisign.com/epp/gen/test";

  /** Namespace prefix associated with EPPTestGenMapFactory. */
  public static final String NS_PREFIX = "test";

  /** Service description for {@code EPPTestGenMapFactory} */
  private EPPService service = null;

  /**
   * Allocates a new {@code EPPTestGenMapFactory}. The service attribute
   * will be initialized with the XML namespace information defined by the
   * {@code EPPTestGenMapFactory} constants:<br>
   *
   * <ul>
   * <li>NS_PREFIX Namespace prefix of {@code EPPTestGenMapFactory}</li>
   * <li>NS Namespace URI of {@code EPPTestGenMapFactory}</li>
   * <li>NS_SCHEMA Namespace schema reference of
   * {@code EPPTestGenMapFactory}</li>
   * </ul>
   */
  public EPPTestGenMapFactory() {
    this.service = new EPPService(NS_PREFIX, NS);
    this.service.setServiceType(EPPService.OBJ_SERVICE);
  }

  /**
   * creates a concrete {@code EPPCommand} from the passed in XML Element
   * tree. {@code aMapElement} must be the root node for the command
   * extension. For example, &lt;domain:create&gt; must be the element passed for
   * a Domain Create Command.
   *
   * @param aMapElement
   *           Mapping Extension EPP XML Element.
   *
   * @return Concrete {@code EPPCommand} instance associated with
   *         {@code aMapElement}.
   *
   * @exception EPPCodecException
   *               Error creating concrete {@code EPPCommand}
   */
  @Override
  public EPPCommand createCommand(Element aMapElement) throws EPPCodecException {
    throw new EPPCodecException("EPPTestGenMapFactory does not support any commands!");
  }

  /**
   * creates a concrete {@code EPPResponse} from the passed in XML Element
   * tree. {@code aMapElement} must be the root node for the command
   * extension. For example, &lt;domain:info-data&gt; must be the element passed
   * for a Domain Info Response.
   *
   * @param aMapElement
   *           Mapping Extension EPP XML Element.
   *
   * @return Concrete {@code EPPResponse} instance associated with
   *         {@code aMapElement}.
   *
   * @exception EPPCodecException
   *               Error creating concrete {@code EPPResponse}
   */
  @Override
  public EPPResponse createResponse(Element aMapElement) throws EPPCodecException {
    throw new EPPCodecException("EPPTestGenMapFactory does not support any responses!");
  }

  /**
   * Gets the {@code EPPService} associated with
   * {@code EPPTestGenMapFactory}. The {@code EPPService} is used by
   * {@code EPPFactory} for distributing the responsibility of creating
   * concrete {@code EPPCommand} and {@code EPPResponse} objects by
   * XML namespace. The XML namespace is defined in the returned
   * {@code EPPService}.
   *
   * @return service description for the Domain Command Mapping.
   */
  @Override
  public EPPService getService() {
    return this.service;
  }

}
