/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.codec.gen;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * The EPP &lt;logout&gt; command is used to end a session with an EPP server.
 * In addition to the standard EPP command elements, the &lt;logout&gt; command
 * SHALL contain an empty &lt;logout&gt; command element. A server MAY also end
 * a session asynchronously due to client inactivity or excessive client session
 * longevity. The parameters for determining excessive client inactivity or
 * session longevity are a matter of server policy and are not specified by this
 * protocol.
 */
public class EPPLogoutCmd extends EPPCommand {
  /** XML root tag name for {@code EPPLogoutCmd}. */
  final static String ELM_NAME = "logout";

  /**
   * Default constructor for EPPLogoutCmd.
   */
  public EPPLogoutCmd() {
  }

  /**
   * Constructor that takes the transaction id required of all
   * {@code EPPCommand}'s.
   *
   * @param aTransId
   *           Client transaction identifier
   */
  public EPPLogoutCmd(String aTransId) {
    super(aTransId);
  }

  /**
   * Get the EPP command type associated with {@code EPPLogoutCmd}.
   *
   * @return {@code EPPCommand.TYPE_LOGOUT}
   */
  public String getType() {
    return EPPCommand.TYPE_LOGOUT;
  }

  /**
   * Get the EPP command Namespace associated with {@code EPPLogoutCmd}.
   *
   * @return {@code EPPCodec.NS}
   */
  public String getNamespace() {
    return EPPCodec.NS;
  }

  /**
   * encode {@code EPPLoginCmd} into a DOM element tree. The &lt;logout&gt;
   * element is created and there are currently no attribute nodes are appended
   * as children. This method is part of the Template Design Pattern, where
   * {@code EPPCommand} provides the public {@code encode} and calls the
   * abstract {@code doGenEncode}.
   *
   * @param aDocument
   *           DOM Document to create elements from
   *
   * @return &lt;logout&gt; root element tree.
   *
   * @exception EPPEncodeException
   *               Error encoding the DOM element tree.
   */
  protected Element doGenEncode(Document aDocument) throws EPPEncodeException {
    Element root = aDocument.createElementNS(EPPCodec.NS, ELM_NAME);

    return root;
  }

  /**
   * decode {@code EPPLogoutCmd} from a DOM element tree. The "logout" element
   * needs to be the value of the {@code aElement} argument. This method is
   * part of the Template Design Pattern, where {@code EPPCommand} provides the
   * public {@code decode} and calls the abstract {@code doGenDecode}.
   *
   * @param aElement
   *           &lt;logout&gt; root element tree.
   *
   * @exception EPPDecodeException
   *               Error decoding the DOM element tree.
   */
  protected void doGenDecode(Element aElement) throws EPPDecodeException {
    if (!aElement.getNamespaceURI().equals(EPPCodec.NS)
          || !aElement.getLocalName().equals(EPPUtil.getLocalName(ELM_NAME))) {
      throw new EPPDecodeException("Invalid tag " + aElement.getTagName() + ", expecting logout");
    }
  }

  /**
   * implements a deep {@code EPPLogoutCmd} compare.
   *
   * @param aObject
   *           {@code EPPLogoutCmd} instance to compare with
   *
   * @return {@code true} if equal; {@code false} otherwise.
   */
  public boolean equals(Object aObject) {
    if (!(aObject instanceof EPPLogoutCmd)) {
      return false;
    }

    if (!super.equals(aObject)) {
      return false;
    }

    return true;
  }

  /**
   * Clone {@code EPPLogoutCmd}.
   *
   * @return clone of {@code EPPLogoutCmd}
   *
   * @exception CloneNotSupportedException
   *               standard Object.clone exception
   */
  public Object clone() throws CloneNotSupportedException {
    EPPLogoutCmd clone = null;

    clone = (EPPLogoutCmd) super.clone();

    return clone;
  }

  /**
   * Implementation of {@code Object.toString}, which will result in an
   * indented XML {@code String} representation of the concrete
   * {@code EPPCodecComponent}.
   *
   * @return Indented XML {@code String} if successful; {@code ERROR}
   *         otherwise.
   */
  public String toString() {
    return EPPUtil.toString(this);
  }

}
