/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-0107  USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.codec.emailFwd;

import org.w3c.dom.Document;
//----------------------------------------------
//
// imports...
//
//----------------------------------------------
// W3C Imports
import org.w3c.dom.Element;

// EPP Imports
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPDeleteCmd;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;


/**
 * Represents an EPP EmailFwd &lt;delete&gt; command that allows a client to
 * delete a emailFwd object. The EPP &lt;delete&gt; command provides a
 * transform operation that allows a client to delete a emailFwd object. In
 * addition to the standard EPP command elements, the &lt;delete&gt; command
 * MUST contain a "emailFwd:delete" element that identifies the emailFwd
 * namespace and the location of the emailFwd schema.     <br><br>
 * 
 * <ul>
 * <li>
 * A &lt;emailFwd:name&gt; element that contains the fully qualified emailFwd
 * name of the object to be deleted.  Use {@code getName} and
 * {@code setName}     to get and set the element.
 * </li>
 * </ul>
 * 
 * <br>{@code EPPReponse} is the response associated     with
 * {@code EPPEmailFwdDeleteCmd}.
 *
 * @see com.verisign.epp.codec.gen.EPPResponse
 */
public class EPPEmailFwdDeleteCmd extends EPPDeleteCmd {
  /** XML Element Name of {@code EPPEmailFwdDeleteCmd} root element. */
  final static String ELM_NAME = "emailFwd:delete";

  /**
   * XML Element Name of a emailFwd name in a
   * {@code EPPEmailFwdDeleteCmd}.
   */
  private final static String ELM_EMAILFWD_NAME = "emailFwd:name";

  /** EmailFwd Name of emailFwd to delete. */
  private String name;

  /**
   * {@code EPPEmailFwdDeleteCmd} default constructor.  The name is
   * initialized to {@code null}.     The name must be set before
   * invoking {@code encode}.
   */
  public EPPEmailFwdDeleteCmd() {
    name = null;
  }

  /**
   * {@code EPPEmailFwdDeleteCmd} constructor that takes the emailFwd
   * name as an argument.
   *
   * @param aTransId Transaction Id associated with command.
   * @param aName EmailFwd name to delete.
   */
  public EPPEmailFwdDeleteCmd(String aTransId, String aName) {
    super(aTransId);

    name = aName;
  }

  /**
   * Gets the EPP command Namespace associated with
   * {@code EPPEmailFwdDeleteCmd}.
   *
   * @return {@code EPPEmailFwdMapFactory.NS}
   */
  public String getNamespace() {
    return EPPEmailFwdMapFactory.NS;
  }

  /**
   * Gets the key for the emailFwd object, which is the emailFwd name.
   * 
   * @return The emailFwd name if set; {@code null} otherwise.
   */
  @Override
  public String getKey() {
    return this.getName();
  }
 
  /**
   * Gets the emailFwd name to delete.
   *
   * @return EmailFwd Name    {@code String} instance if defined;
   *       {@code null} otherwise.
   */
  public String getName() {
    return name;
  }

  /**
   * Sets the emailFwd name to delete.
   *
   * @param aName EmailFwd Name
   */
  public void setName(String aName) {
    name = aName;
  }

  /**
   * Compare an instance of {@code EPPEmailFwdDeleteCmd} with this
   * instance.
   *
   * @param aObject Object to compare with.
   *
   * @return DOCUMENT ME!
   */
  public boolean equals(Object aObject) {
    if (!(aObject instanceof EPPEmailFwdDeleteCmd)) {
      return false;
    }

    if (!super.equals(aObject)) {
      return false;
    }

    EPPEmailFwdDeleteCmd theComp = (EPPEmailFwdDeleteCmd) aObject;

    // Name
    if (
      !(
          (name == null) ? (theComp.name == null)
                     : name.equals(theComp.name)
        )) {
      return false;
    }

    return true;
  }

  /**
   * Clone {@code EPPEmailFwdDeleteCmd}.
   *
   * @return clone of {@code EPPEmailFwdDeleteCmd}
   *
   * @exception CloneNotSupportedException standard Object.clone exception
   */
  public Object clone() throws CloneNotSupportedException {
    EPPEmailFwdDeleteCmd clone = (EPPEmailFwdDeleteCmd) super.clone();

    return clone;
  }

  /**
   * Encode a DOM Element tree from the attributes of the
   * {@code EPPEmailFwdDeleteCmd} instance.
   *
   * @param aDocument DOM Document that is being built.  Used as an Element
   *      factory.
   *
   * @return Root DOM Element representing the
   *       {@code EPPEmailFwdDeleteCmd} instance.
   *
   * @exception EPPEncodeException Unable to encode
   *        {@code EPPEmailFwdDeleteCmd} instance.
   */
  protected Element doEncode(Document aDocument) throws EPPEncodeException {
    // Validate state
    if (name == null) {
      throw new EPPEncodeException("name required attribute is not set");
    }

    Element root =
      aDocument.createElementNS(EPPEmailFwdMapFactory.NS, ELM_NAME);

    root.setAttribute("xmlns:emailFwd", EPPEmailFwdMapFactory.NS);

    // Name
    EPPUtil.encodeString(
               aDocument, root, name, EPPEmailFwdMapFactory.NS,
               ELM_EMAILFWD_NAME);

    return root;
  }

  /**
   * Decode the {@code EPPEmailFwdDeleteCmd} attributes from the
   * aElement DOM Element tree.
   *
   * @param aElement Root DOM Element to decode
   *      {@code EPPEmailFwdDeleteCmd} from.
   *
   * @exception EPPDecodeException Unable to decode aElement
   */
  protected void doDecode(Element aElement) throws EPPDecodeException {
    // EmailFwd Name
    name =
      EPPUtil.decodeString(
                 aElement, EPPEmailFwdMapFactory.NS,
                 ELM_EMAILFWD_NAME);
  }
}
