/***********************************************************
Copyright (C) 2023 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/

package com.verisign.epp.codec.ttl.v1_0;

import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.verisign.epp.codec.gen.EPPEncodeException;

/**
 * TTL Info Data Extension that enables a client to pass the TTL values with a
 * info response.
 */
public class EPPTtlInfData extends EPPTtlExtension {

  private static final long serialVersionUID = 1L;

  /**
   * XML local name for {@code EPPTtlInfData}.
   */
  public static final String ELM_LOCALNAME = "infData";

  /**
   * XML root tag for {@code EPPTtlInfData}.
   */
  public static final String ELM_NAME = EPPTtlExtFactory.NS_PREFIX + ":" + ELM_LOCALNAME;

  /**
   * Returns the local name &quot;infData&quot; for the info response extension.
   * 
   * @return Local name &quot;infData&quot; for the info response extension.
   */
  protected String getLocalName() {
    return ELM_LOCALNAME;
  }

  /**
   * Default constructor for {@code EPPTtlInfData}.
   */
  public EPPTtlInfData() {
  }
  
  /**
   * Constructor for {@code EPPTtlInfData} that takes a single TTL.
   * 
   * @param aTtl
   *           A single TLL value
   */
  public EPPTtlInfData(EPPTtl aTtl) {
    this.addTtl(aTtl);
  }

  /**
   * Constructor for {@code EPPTtlInfData} that a list of TTLs.
   * 
   * @param aTtls
   *           A list of TTLs
   */
  public EPPTtlInfData(List<EPPTtl> aTtls) {
    this.setTtls(aTtls);
  }

  /**
   * Encode of a {@code EPPTtlInfData} instance that includes checks of the
   * TTLs.
   * 
   * @param aDocument
   *           DOM Document, which acts is an Element factory
   * 
   * @return Element Root element associated with the object
   * 
   * @exception EPPEncodeException
   *               Error encoding {@code EPPTtlExtension}
   */
  public Element encode(Document aDocument) throws EPPEncodeException {
    return super.encode(aDocument);
  }

  /**
   * Returns the XML namespace associated with the {@code EPPCodecComponent}.
   * 
   * @return XML namespace for the {@code EPPCodecComponent}.
   */
  @Override
  public String getNamespace() {
    return EPPTtlExtFactory.NS;
  }

}
