/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-0107  USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/

/**
 * The information in this document is proprietary to VeriSign and the VeriSign
 * Registry Business. It may not be used, reproduced or disclosed without the
 * written approval of the General Manager of VeriSign Global Registry
 * Services. PRIVILEDGED AND CONFIDENTIAL VERISIGN PROPRIETARY INFORMATION
 * REGISTRY SENSITIVE INFORMATION Copyright (c) 2002 VeriSign, Inc.  All
 * rights reserved.
 */
package com.verisign.epp.codec.persreg;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;

/**
 * Personal Registration &lt;genDataType&gt; complexType, which is reused
 * by:<br>
 * <br>
 * 
 * <ul>
 * <li>&lt;creData&gt; - {@code EPPPersRegCreateData}</li>
 * <li>&lt;renData&gt; - {@code EPPPersRegRenewData}</li>
 * <li>&lt;trnData&gt; - {@code EPPPersRegTransferData}</li>
 * </ul>
 */
public abstract class EPPPersRegGenData implements EPPCodecComponent {
  /** XML tag name for the {@code _bundledRate} attribute. */
  private static final String ELM_BUNDLED_RATE = "persReg:bundledRate";

  /** Bundled rate flag. */
  private boolean _bundledRate;

  /**
   * Default constructor. Bundled flag defaults to {@code false}.
   */
  public EPPPersRegGenData() {
    _bundledRate = false;
  }

  /**
   * Constructor that sets the bundled flag.
   *
   * @param aIsBundledRate
   *           Does the bundled rate apply?
   */
  public EPPPersRegGenData(boolean aIsBundledRate) {
    _bundledRate = aIsBundledRate;
  }

  /**
   * Does the bundled rate apply?
   *
   * @return {@code true} if bundled rate applies; {@code false} otherwise.
   */
  public boolean isBundledRate() {
    return _bundledRate;
  }

  /**
   * Sets the bundled rate flag.
   *
   * @param aIsBundledRate
   *           Does the bundled rate apply?
   */
  public void setIsBundedRate(boolean aIsBundledRate) {
    _bundledRate = aIsBundledRate;
  }

  /**
   * Compare an instance of {@code EPPPersGenData} with this instance.
   *
   * @param aObject
   *           Object to compare with.
   *
   * @return {@code true} if equal; {@code false} otherwise.
   */
  public boolean equals(Object aObject) {
    if (!(aObject instanceof EPPPersRegGenData)) {
      return false;
    }

    EPPPersRegGenData theComp = (EPPPersRegGenData) aObject;

    if (_bundledRate != theComp._bundledRate) {
      return false;
    }

    return true;
  }

  /**
   * encode instance into a DOM element tree. A DOM Document is passed as an
   * argument and functions as a factory for DOM objects. The root element
   * associated with the instance is created and each instance attribute is
   * appended as a child node.
   *
   * @param aDocument
   *           DOM Document, which acts is an Element factory
   *
   * @return Element Root element associated with the object
   *
   * @exception EPPEncodeException
   *               Error encoding {@code EPPPersRegGenData}
   */
  public Element encode(Document aDocument) throws EPPEncodeException {
    Element root = aDocument.createElementNS(EPPPersRegExtFactory.NS, getRootElm());
    root.setAttribute("xmlns:persReg", EPPPersRegExtFactory.NS);

    EPPUtil.encodeBoolean(aDocument, root, Boolean.valueOf(_bundledRate), EPPPersRegExtFactory.NS, ELM_BUNDLED_RATE);

    return root;
  }

  /**
   * decode a DOM element tree to initialize the instance attributes. The
   * {@code aElement} argument represents the root DOM element and is used to
   * traverse the DOM nodes for instance attribute values.
   *
   * @param aElement
   *           {@code Element} to decode
   *
   * @exception EPPDecodeException
   *               Error decoding {@code Element}
   */
  public void decode(Element aElement) throws EPPDecodeException {
    // Bundled Rate
    Boolean val = EPPUtil.decodeBoolean(aElement, EPPPersRegExtFactory.NS, ELM_BUNDLED_RATE);

    if (val != null) {
      _bundledRate = val.booleanValue();
    }
    else {
      throw new EPPDecodeException("bundledRate required attribute is not decoded");
    }
  }

  /**
   * clone an {@code EPPCodecComponent}.
   *
   * @return clone of concrete {@code EPPPersRegGenData}
   *
   * @exception CloneNotSupportedException
   *               standard Object.clone exception
   */
  public Object clone() throws CloneNotSupportedException {
    EPPPersRegGenData clone = (EPPPersRegGenData) super.clone();

    return clone;
  }

  /**
   * Gets the root element name to use. The derived classes must define what
   * the root element name is.
   *
   * @return Root element name
   */
  protected abstract String getRootElm();
}
