/***********************************************************
Copyright (C) 2019 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
 ***********************************************************/

package com.verisign.epp.codec.loginsecpolicy.v04;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EqualityUtil;

/**
 * Login Security Policy Create Extension that enables a client to pass the
 * login security policy information with a registry info response.
 */
public class EPPLoginSecPolicyInfData implements EPPCodecComponent {

  /**
   * Category for logging
   */
      private static Logger cat = LoggerFactory.getLogger(EPPLoginSecPolicyInfData.class);
        

  /**
   * XML local name for {@code EPPLoginSecPolicyInfData}.
   */
  public static final String ELM_LOCALNAME = "infData";

  /**
   * XML root tag for {@code EPPLoginSecPolicyInfData}.
   */
  public static final String ELM_NAME = EPPLoginSecPolicyExtFactory.NS_PREFIX + ":" + ELM_LOCALNAME;

  /**
   * Instance of {@link EPPLoginSecPolicySystem} that is contained by the
   * extension.
   */
  private EPPLoginSecPolicySystem system = null;

  /**
   * Creates an empty {@code EPPLoginSecPolicyInfData} object. {@code system}
   * is set to {@code null}. Use {@code setSystem} to set {@code system}
   * attribute before sending the info response.
   */
  public EPPLoginSecPolicyInfData() {
  }

  /**
   * Creates a new {@code EPPLoginSecPolicyInfData} object that will set the
   * login security policy for the system.
   *
   * @param aSystem
   *           Instance of {@link EPPLoginSecPolicySystem} to create
   */
  public EPPLoginSecPolicyInfData(EPPLoginSecPolicySystem aSystem) {
    this.system = aSystem;
  }

  /**
   * Gets the contained system of the extension.
   *
   * @return Instance of contained {@link EPPLoginSecPolicySystem}
   */
  public EPPLoginSecPolicySystem getSystem() {
    return this.system;
  }

  /**
   * Sets the contained system of the extension.
   *
   * @param aSystem
   *           Instance of {@link EPPLoginSecPolicySystem}
   */
  public void setSystem(EPPLoginSecPolicySystem aSystem) {
    this.system = aSystem;
  }

  /**
   * Encode instance into a DOM element tree. A DOM Document is passed as an
   * argument and functions as a factory for DOM objects. The root element
   * associated with the instance is created and each instance attribute is
   * appended as a child node.
   *
   * @param aDocument
   *           DOM Document, which acts is an Element factory
   *
   * @return Element Root element associated with the object
   *
   * @exception EPPEncodeException
   *               Error encoding {@code EPPLoginSecPolicyInfData}
   */
  @Override
  public Element encode(Document aDocument) throws EPPEncodeException {

    if (aDocument == null) {
      throw new EPPEncodeException("aDocument is null" + " on in EPPLoginSecPolicyInfData.encode(Document)");
    }

    // Check for required attributes
    if (this.system == null) {
      throw new EPPEncodeException("zone is null in EPPLoginSecPolicyInfData.encode(Document).");
    }

    // Create root element
    Element root = aDocument.createElementNS(EPPLoginSecPolicyExtFactory.NS, EPPLoginSecPolicyInfData.ELM_NAME);

    // System
    EPPUtil.encodeComp(aDocument, root, this.system);

    return root;
  }

  /**
   * Decode a DOM element tree to initialize the instance attributes. The
   * {@code aElement} argument represents the root DOM element and is used to
   * traverse the DOM nodes for instance attribute values.
   *
   * @param aElement
   *           {@code Element} to decode
   *
   * @exception EPPDecodeException
   *               Error decoding {@code Element}
   */
  @Override
  public void decode(Element aElement) throws EPPDecodeException {

    // System
    this.system = (EPPLoginSecPolicySystem) EPPUtil.decodeComp(aElement, EPPLoginSecPolicyExtFactory.NS,
          EPPLoginSecPolicySystem.ELM_NAME, EPPLoginSecPolicySystem.class);
  }

  /**
   * clone an {@code EPPCodecComponent}.
   *
   * @return clone of concrete {@code EPPLoginSecPolicyInfData}
   *
   * @exception CloneNotSupportedException
   *               standard Object.clone exception
   */
  @Override
  public Object clone() throws CloneNotSupportedException {
    EPPLoginSecPolicyInfData clone = (EPPLoginSecPolicyInfData) super.clone();

    if (this.system != null) {
      clone.system = (EPPLoginSecPolicySystem) this.system.clone();
    }

    return clone;
  }

  /**
   * Implementation of {@code Object.toString}, which will result in an
   * indented XML {@code String} representation of the concrete
   * {@code EPPCodecComponent}.
   *
   * @return Indented XML {@code String} if successful; {@code ERROR}
   *         otherwise.
   */
  @Override
  public String toString() {
    return EPPUtil.toString(this);
  }

  /**
   * Compare an instance of {@code EPPLoginSecPolicyInfData} with this
   * instance.
   *
   * @param aObject
   *           Object to compare with.
   *
   * @return {@code true} if equal; {@code false} otherwise.
   */
  @Override
  public boolean equals(Object aObject) {
    if (!(aObject instanceof EPPLoginSecPolicyInfData)) {
      cat.error("EPPLoginSecPolicyInfData.equals(): " + aObject.getClass().getName()
            + " not EPPLoginSecPolicyInfData instance");

      return false;
    }

    EPPLoginSecPolicyInfData theComp = (EPPLoginSecPolicyInfData) aObject;

    // System
    if (!EqualityUtil.equals(this.system, theComp.system)) {
      cat.error("EPPLoginSecPolicyInfData.equals(): zone not equal");
      return false;
    }

    return true;
  }

  /**
   * Returns the XML namespace associated with the {@code EPPCodecComponent}.
   *
   * @return XML namespace for the {@code EPPCodecComponent}.
   */
  @Override
  public String getNamespace() {
    return EPPLoginSecPolicyExtFactory.NS;
  }

}
