/***********************************************************
Copyright (C) 2018 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.serverstub;

import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;

/**
 * Sub Gen Handler for use with the login security extension.  
 * This interface is used to support handling multiple versions of the 
 * login security extension, where each different version of the 
 * login security must implement this interface.  
 */
public interface LoginSecSubGenHandler {
  
  /**
   * Handle the login command
   * 
   * @param aEvent Event must contain an EPPLoginCmd for handling
   * @param aData Extra server data, which is <code>SessionData</code> for the Stub Server.
   *
   * @return Response to handling the login command
   */
  EPPEventResponse doLogin(EPPEvent aEvent, Object aData);
}
