/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.transport.server;

import com.verisign.epp.transport.EPPConException;

/**
 * Singleton of the {@link EPPSSLServer}.
 */
public class EPPSSLServerSingle extends EPPSSLServer {
	/** Singleton instance */
	private static EPPSSLServerSingle instance = null;

	/**
	 * Private constructor for the Singleton pattern.
	 *
	 * @throws EPPConException
	 *            Exception starting the server
	 */
	private EPPSSLServerSingle() throws EPPConException {
	}

	/**
	 * Gets the Singleton instance, which will throw the {@code EPPConException}
	 * if there is an error with the Singleton instantiation.
	 *
	 * @return Singleton instance of {@code EPPSSLServerSingle} 
	 *
	 * @throws EPPConException
	 *            Error creating Singleton instance
	 */
	public static EPPSSLServerSingle getInstance() throws EPPConException {
		if (instance == null) {
			instance = new EPPSSLServerSingle();
		}

		return instance;
	}
}
