/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.transport;

/**
 * Interface to handle new EPP connections that includes returning the EPP
 * greeting and starting an EPP command processing loop
 */
public interface ServerEventHandler extends Cloneable {
	/**
	 * Handle a new EPP connection that includes returning the EPP greeting and
	 * starting an EPP command processing loop
	 *
	 * @param aInputStream
	 *           Input stream associated with the new EPP connection
	 * @param aOutputStream
	 *           Output stream associated with the new EPP connection
	 */
	public void handleConnection(java.io.InputStream aInputStream, java.io.OutputStream aOutputStream);

	/**
	 * Clone the {@code ServerEventHandler} state.
	 *
	 * @return {@code ServerEventHandler} instance
	 *
	 * @throws java.lang.CloneNotSupportedException
	 *            Exception with cloning
	 */
	public Object clone() throws java.lang.CloneNotSupportedException;
}
