/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/
package com.verisign.epp.framework;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * The {@code EPPAssembler} interface defines an interface for serializing
 * {@link EPPEvent} objects and {@link EPPEventResponse} objects. Implementing
 * classes should define the format of the input and output streams.
 *
 * @see com.verisign.epp.framework.EPPXMLAssembler
 * @see com.verisign.epp.framework.EPPEventResponse
 * @see com.verisign.epp.framework.EPPEvent
 * @see com.verisign.epp.framework.EPPAssemblerException
 */
public interface EPPAssembler {
  /**
   * Takes an {@code EPPEventResponse} and serializes it to an {@code 
   * OutputStream}
   *
   * @param aResponse
   *           The response that will be serialized
   * @param aOutputStream
   *           The OutputStream that the response will be serialized to.
   * @param aData
   *           Optional Client Data {@code Object}
   *
   * @exception EPPAssemblerException
   *               Error serializing the {@code EPPEventResponse}
   */
  public void toStream(EPPEventResponse aResponse, OutputStream aOutputStream, Object aData)
        throws EPPAssemblerException;

  /**
   * Takes an {@code InputStream} and creates a {@code EPPEvent}
   *
   * @param aInputStream
   *           The InputStream to read data from.
   * @param aData
   *           Optional Client Data {@code Object}
   *
   * @return EPPEvent The {@code EPPEvent} that is created from the
   *         InputStream
   *
   * @exception EPPAssemblerException
   *               Error creating the {@code  EPPEvent
   *        }
   */
  public EPPEvent toEvent(InputStream aInputStream, Object aData) throws EPPAssemblerException;
}
