package com.verisign.epp.codec.defReg;

import org.junit.Test;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;

public class EPPDefRegCreateCmdTst {

  /**
   * Verify that a {@code <create>} command is valid as long as it has a name and an authInfo.
   *
   * @throws EPPCodecException not really
   */
  @Test
  public void testValidateState() throws EPPCodecException {
    EPPDefRegCreateCmd cmd = new EPPDefRegCreateCmd();
    cmd.setDefRegName(new EPPDefRegName());
    cmd.setAuthInfo(new EPPAuthInfo());
    cmd.validateState();
  }

  /**
   * Verify that a {@code <create>} command without a name is invalid.
   *
   * @throws EPPCodecException if the command does not have a name
   */
  @Test(expected = EPPCodecException.class)
  public void testValidateStateNoName() throws EPPCodecException {
    EPPDefRegCreateCmd cmd = new EPPDefRegCreateCmd();
    cmd.setAuthInfo(new EPPAuthInfo());
    cmd.validateState();
  }

  /**
   * Verify that a {@code <create>} command without an authInfo is invalid.
   *
   * @throws EPPCodecException if the command does not have a name
   */
  @Test(expected = EPPCodecException.class)
  public void testValidateStateNoAuthInfo() throws EPPCodecException {
    EPPDefRegCreateCmd cmd = new EPPDefRegCreateCmd();
    cmd.setDefRegName(new EPPDefRegName());
    cmd.validateState();
  }
}
