/***********************************************************
Copyright (C) 2004 VeriSign, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

http://www.verisign.com/nds/naming/namestore/techdocs.html
***********************************************************/

package com.verisign.epp.codec.allocationtoken;

import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPCodecTst;
import com.verisign.epp.codec.gen.EPPEncodeDecodeStats;
import com.verisign.epp.codec.gen.EPPFactory;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.util.TestThread;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Is a unit test of the com.verisign.epp.codec.namestoreext package. The unit
 * test will execute, gather statistics, and output the results of a test of
 * each com.verisign.epp.codec.namestoreext package concrete extension
 * <code>EPPCodecComponent</code>'s. The Domain and Host commands and responses
 * are used to test extending both.<br>
 * <br>
 * The unit test is dependent on the use of <a
 * href=http://www.mcwestcorp.com/Junit.html>JUNIT 3.5</a><br>
 * <br>
 *
 * @author $Author: jim $
 * @version $Revision: 1.4 $
 */
public class EPPAllocationTokenTst {
  /**
   * Number of unit test iterations to run. This is set in
   * <code>EPPCodecTst.main</code>
   */
  static private long numIterations = 1;

  /**
   * Unit test of extending the Domain and host create commands and responses
   * to specify the sub-product. <br>
   * This test will be invoked by JUNIT, since it is prefixed with "test" and
   * is a public method.
   */
  @Test
  public void testAllocationToken() {
    EPPCodecTst.printStart("testAllocationToken");

    // Generic objects
    EPPTransId respTransId = new EPPTransId("ABC-12345", "54321-XYZ");
    EPPEncodeDecodeStats theStats;

    // -- Extend Domain Create Command
    EPPDomainCreateCmd theDomainCommand;
    theDomainCommand = new EPPDomainCreateCmd("ABC-12345", "example.tld", new EPPAuthInfo("2fooBAR"));

    // Add Extension
    theDomainCommand.addExtension(new EPPAllocationToken("abc123"));

    theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
    System.out.println(theStats);

    EPPCodecTst.printEnd("testAllocationToken");
  }

  /**
   * Unit test of extending the domain info command with the allocation token
   * info extension.
   */
  @Test
  public void testAllocationTokenInfo() {
    EPPCodecTst.printStart("testAllocationTokenInfo");

    EPPEncodeDecodeStats theStats;

    // -- Extend Domain Info Command
    EPPDomainInfoCmd theDomainCommand;
    theDomainCommand = new EPPDomainInfoCmd("ABC-12345", "example.tld");

    // Add Extension
    theDomainCommand.addExtension(new EPPAllocationTokenInfo());

    theStats = EPPCodecTst.testEncodeDecode(theDomainCommand);
    System.out.println(theStats);

    EPPCodecTst.printEnd("testAllocationTokenInfo");
  }

  /**
   * JUNIT <code>suite</code> static method, which returns the tests associated
   * with <code>EPPAllocationTokenTst</code>.
   */
  @BeforeClass
  public static void setup() {
    EPPCodecTst.initEnvironment();

    // iterations Property
    String numIterProp = System.getProperty("iterations");

    if (numIterProp != null) {
      numIterations = Integer.parseInt(numIterProp);
    }

    // Add the EPPNSProductExtFactory to the EPPCodec.
    try {
      EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.host.EPPHostMapFactory");
      EPPFactory.getInstance().addMapFactory("com.verisign.epp.codec.domain.EPPDomainMapFactory");
      EPPFactory.getInstance().addExtFactory("com.verisign.epp.codec.allocationtoken.EPPAllocationTokenExtFactory");
    }
    catch (EPPCodecException e) {
      Assert.fail("EPPCodecException adding factories to EPPCodec: " + e);
    }
  }

  /**
   * Sets the number of iterations to run per test.
   *
   * @param aNumIterations
   *           number of iterations to run per test
   */
  public static void setNumIterations(long aNumIterations) {
    numIterations = aNumIterations;
  }

}
