/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.server;

import com.verisign.epp.transport.ServerEventHandler;
import net.luminis.quic.QuicStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPQuicServerThread
extends Thread {
    private static Logger cat = LoggerFactory.getLogger(EPPQuicServerThread.class);
    private QuicStream quicStream;
    private ServerEventHandler handler = null;

    public EPPQuicServerThread(QuicStream aStream, ServerEventHandler aHandler) {
        super("EPPMultiServerThread");
        this.quicStream = aStream;
        this.handler = aHandler;
    }

    @Override
    public void run() {
        cat.info("run(): enter");
        if (this.handler == null) {
            cat.error("The Server Handler is not Set");
            return;
        }
        try {
            ServerEventHandler theServerEventHandler = (ServerEventHandler)this.handler.clone();
            theServerEventHandler.handleConnection(this.quicStream.getInputStream(), this.quicStream.getOutputStream());
        }
        catch (CloneNotSupportedException ex) {
            cat.error("Server Run : CloneNotSupportedException : " + ex.getMessage(), (Throwable)ex);
            return;
        }
        cat.info("run(): exit");
    }
}

