/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport.server;

import com.verisign.epp.transport.EPPConException;
import com.verisign.epp.transport.EPPServerCon;
import com.verisign.epp.transport.ServerEventHandler;
import com.verisign.epp.transport.client.EPPSSLConfig;
import com.verisign.epp.transport.client.EPPSSLContext;
import com.verisign.epp.transport.client.EPPSSLImpl;
import com.verisign.epp.transport.server.EPPQuicServerThread;
import com.verisign.epp.util.EPPEnv;
import com.verisign.epp.util.EPPEnvException;
import java.io.File;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import net.luminis.quic.QuicConnection;
import net.luminis.quic.QuicStream;
import net.luminis.quic.log.NullLogger;
import net.luminis.quic.server.ApplicationProtocolConnection;
import net.luminis.quic.server.ApplicationProtocolConnectionFactory;
import net.luminis.quic.server.ServerConnectionConfig;
import net.luminis.quic.server.ServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPQuicServer
implements EPPServerCon {
    private static Logger cat = LoggerFactory.getLogger(EPPQuicServer.class);
    private ServerConnector serverConnector = null;
    private boolean listening = false;
    private ServerEventHandler handler = null;
    private int portNumber = 0;
    private EPPSSLContext sslContext;

    protected String getSSLPropertyListString(String[] aList) {
        if (aList == null) {
            return null;
        }
        Object theStr = "";
        for (int i = 0; i < aList.length; ++i) {
            if (i > 0) {
                theStr = (String)theStr + " ";
            }
            theStr = (String)theStr + aList[i];
        }
        return theStr;
    }

    public EPPQuicServer() throws EPPConException {
        cat.debug("EPPQuicServer.EPPQuicServer(): entering Constructor");
        if (!EPPSSLImpl.isInitialized()) {
            cat.debug("EPPQuicServer: Initializing SSL with default EPPSSLImpl");
            EPPSSLImpl.initialize();
        }
        this.sslContext = EPPSSLImpl.getEPPSSLContext();
    }

    @Override
    public void RunServer(ServerEventHandler aHandler) throws EPPConException {
        cat.debug("EPPQuicServer.RunServer(): entering Method");
        this.handler = aHandler;
        this.loop();
        this.close();
        cat.debug("EPPQuicServer.RunServer(): Exiting Method");
    }

    public void loop() throws EPPConException {
        cat.debug("EPPQuicServer.loop(): Entering Method");
        EPPSSLConfig theSslConfig = this.sslContext.getSslConfig();
        try {
            this.portNumber = EPPEnv.getServerPort();
        }
        catch (EPPEnvException ex) {
            cat.error("Connection Failed Due to : " + ex.getMessage(), (Throwable)ex);
            throw new EPPConException("Connection Failed Due to : " + ex.getMessage());
        }
        try {
            ServerConnector.Builder theBuilder = ServerConnector.builder();
            theBuilder.withPort(this.portNumber);
            char[] theIdentityPassPhrase = null;
            if (theSslConfig.getIdentityPassPhrase() != null) {
                theIdentityPassPhrase = theSslConfig.getIdentityPassPhrase().toCharArray();
            }
            theBuilder.withKeyStore(KeyStore.getInstance(new File(theSslConfig.getIdentityFileName()), theIdentityPassPhrase), "eppsdk", theSslConfig.getIdentityKeyPassPhraseCharArray());
            ServerConnectionConfig.Builder theServerConnectionConfigBuilder = ServerConnectionConfig.builder();
            theServerConnectionConfigBuilder.maxOpenPeerInitiatedBidirectionalStreams(1);
            ServerConnectionConfig theServerConnectionConfig = theServerConnectionConfigBuilder.build();
            theBuilder.withConfiguration(theServerConnectionConfig);
            theBuilder.withLogger((net.luminis.quic.log.Logger)new NullLogger());
            this.serverConnector = theBuilder.build();
            this.serverConnector.registerApplicationProtocol("eoq", (ApplicationProtocolConnectionFactory)new EoQProtocolConnectionFactory(this.handler));
            this.listening = true;
            this.serverConnector.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            cat.error("Exception creating QUIC connection/stream: " + ex);
            throw new EPPConException("Exception creating QUIC connection/stream");
        }
        cat.debug("EPPQuicServer.loop(): Exting Method");
    }

    public void close() throws EPPConException {
        cat.debug("EPPQuicServer.close(): Entering Method");
        cat.debug("EPPQuicServer.close(): Exting Method");
    }

    public boolean isListening() {
        return this.listening;
    }

    public void setListening(boolean aListening) {
        this.listening = aListening;
    }

    private static class EoQProtocolConnectionFactory
    implements ApplicationProtocolConnectionFactory {
        private ServerEventHandler handler = null;

        public EoQProtocolConnectionFactory(ServerEventHandler aHandler) {
            this.handler = aHandler;
        }

        public EoQProtocolConnection createConnection(String aProtocol, QuicConnection aQuicConnection) {
            return new EoQProtocolConnection(aQuicConnection, this.handler);
        }
    }

    private static class EoQProtocolConnection
    implements ApplicationProtocolConnection {
        private static Logger cat = LoggerFactory.getLogger(EoQProtocolConnection.class);
        private QuicConnection quicConnection;
        private ServerEventHandler handler = null;
        private List<EPPQuicServerThread> quicStreamThreads = new ArrayList<EPPQuicServerThread>();

        public EoQProtocolConnection(QuicConnection aQuicConnection, ServerEventHandler aHandler) {
            cat.debug("Connection created:" + aQuicConnection);
            this.quicConnection = aQuicConnection;
            this.handler = aHandler;
        }

        public void acceptPeerInitiatedStream(QuicStream aStream) {
            cat.debug("Stream accepted with connection:" + this.quicConnection + ", and stream id: " + aStream.getStreamId());
            EPPQuicServerThread theStreamThread = new EPPQuicServerThread(aStream, this.handler);
            theStreamThread.start();
            this.quicStreamThreads.add(theStreamThread);
        }
    }
}

