/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.transport;

import com.verisign.epp.transport.ServerEventHandler;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPPServerThread
extends Thread {
    private static Logger cat = LoggerFactory.getLogger(EPPServerThread.class);
    private Socket socket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private ServerEventHandler handler = null;

    public EPPServerThread(Socket aSocket, ServerEventHandler aHandler) throws IOException {
        super("EPPMultiServerThread");
        this.socket = aSocket;
        this.handler = aHandler;
        if (aSocket instanceof SSLSocket) {
            ((SSLSocket)aSocket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                @Override
                public void handshakeCompleted(HandshakeCompletedEvent aEvent) {
                    try {
                        X509Certificate thePeerCert = (X509Certificate)aEvent.getPeerCertificates()[0];
                        X509Certificate theRootCert = (X509Certificate)aEvent.getPeerCertificates()[aEvent.getPeerCertificates().length - 1];
                        cat.debug("Server SSL Handshake: Cipher = " + aEvent.getCipherSuite() + ": Protocol = " + aEvent.getSession().getProtocol() + ": Peer (name, serial #, issuer) = (" + thePeerCert.getIssuerX500Principal().getName() + "," + thePeerCert.getSerialNumber() + "," + thePeerCert.getIssuerX500Principal().getName() + "): Root (name, serial #) = (" + thePeerCert.getIssuerX500Principal().getName() + "," + thePeerCert.getSerialNumber() + "," + thePeerCert.getIssuerX500Principal().getName() + ")");
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        // empty catch block
                    }
                }
            });
        }
        try {
            this.inputStream = this.socket.getInputStream();
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream(), 20480);
        }
        catch (IOException myException) {
            myException.printStackTrace();
            throw new IOException(myException.getMessage());
        }
    }

    @Override
    public void run() {
        cat.info("run(): enter");
        if (this.handler == null) {
            cat.error("The Server Handler is not Set");
            return;
        }
        try {
            ServerEventHandler myConHandler = (ServerEventHandler)this.handler.clone();
            myConHandler.handleConnection(this.inputStream, this.outputStream);
        }
        catch (CloneNotSupportedException myException) {
            cat.error("Server Run : CloneNotSupportedException : " + myException.getMessage(), (Throwable)myException);
            return;
        }
        cat.info("run(): Closing socket");
        try {
            this.socket.close();
        }
        catch (IOException myException) {
            cat.error("Server Run : IOException When Closing the Connection : " + myException.getMessage(), (Throwable)myException);
            return;
        }
        cat.info("run(): exit");
    }
}

