/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub.unhandlednamespaces.v1_0;

import com.verisign.epp.codec.changepoll.EPPChangeCaseId;
import com.verisign.epp.codec.changepoll.EPPChangeData;
import com.verisign.epp.codec.changepoll.EPPChangeOperation;
import com.verisign.epp.codec.domain.EPPDomainContact;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainStatus;
import com.verisign.epp.codec.domain.EPPDomainTransferResp;
import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPMsgQueue;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.rgpext.EPPRgpExtInfData;
import com.verisign.epp.codec.rgpext.EPPRgpExtStatus;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtDsData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtInfData;
import com.verisign.epp.codec.unhandlednamespaces.v1_0.EPPUnhandledNamespacesResponseFilter;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.serverstub.SessionData;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnhandledNamespacesDomainHandler
extends DomainHandler {
    private static Logger cat = LoggerFactory.getLogger(UnhandledNamespacesDomainHandler.class);
    EPPUnhandledNamespacesResponseFilter unhandledNamespaceFilter = new EPPUnhandledNamespacesResponseFilter();

    @Override
    public EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPDomainCreateCmd theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
        cat.debug("doDomainCreate: command = [" + theCommand + "]");
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        if (theCommand.getName().equalsIgnoreCase("un-poll-messages.com")) {
            EPPDomainInfoResp theChangePollMsg = new EPPDomainInfoResp();
            EPPMsgQueue theMsgQueue = new EPPMsgQueue();
            theMsgQueue.setMsg("Registry initiated update of domain.");
            theChangePollMsg.setMsgQueue(theMsgQueue);
            theChangePollMsg.setName(theCommand.getName());
            theChangePollMsg.setRoid("EXAMPLE1-REP");
            theChangePollMsg.setRegistrant("jd1234");
            theChangePollMsg.addContact(new EPPDomainContact("sh8013", "admin"));
            theChangePollMsg.addContact(new EPPDomainContact("sh8013", "tech"));
            theChangePollMsg.setClientId("ClientX");
            theChangePollMsg.setCreatedBy("ClientY");
            theChangePollMsg.setLastUpdatedBy("ClientX");
            theChangePollMsg.setCreatedDate(new GregorianCalendar(2012, 5, 3).getTime());
            theChangePollMsg.setLastUpdatedDate(new GregorianCalendar(2013, 11, 22).getTime());
            theChangePollMsg.setExpirationDate(new GregorianCalendar(2014, 5, 3).getTime());
            theChangePollMsg.setTransId(new EPPTransId(theCommand.getTransId(), "54322-XYZ"));
            theChangePollMsg.setResult(1000);
            theChangePollMsg.addStatus(new EPPDomainStatus("serverUpdateProhibited"));
            theChangePollMsg.addStatus(new EPPDomainStatus("serverDeleteProhibited"));
            theChangePollMsg.addStatus(new EPPDomainStatus("serverTransferProhibited"));
            EPPChangeData changeData = new EPPChangeData(new EPPChangeOperation("update"), new GregorianCalendar(2013, 11, 22).getTime(), "12345-XYZ", "URS Admin", "after", new EPPChangeCaseId("urs123", "urs"), "URS Lock", null);
            theChangePollMsg.addExtension(changeData);
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", theChangePollMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error("doDomainCreate: Error adding change poll message [" + theChangePollMsg + "]: " + ex);
                EPPResult theResult = new EPPResult(2400);
                EPPResponse theResponse = new EPPResponse(theTransId, theResult);
                return new EPPEventResponse(theResponse);
            }
            EPPDomainTransferResp theTransMsg = new EPPDomainTransferResp();
            theMsgQueue = new EPPMsgQueue();
            theMsgQueue.setMsg("Transfer Auto Approved.");
            theTransMsg.setActionClient("ClientY");
            theTransMsg.setActionDate(new GregorianCalendar(2018, 8, 24).getTime());
            theTransMsg.setExpirationDate(new GregorianCalendar(2018, 8, 24).getTime());
            theTransMsg.setName(theCommand.getName());
            theTransMsg.setRequestClient("ClientX");
            theTransMsg.setRequestDate(new GregorianCalendar(2018, 8, 24).getTime());
            theTransMsg.setTransferStatus("serverApproved");
            try {
                EPPPollQueueMgr.getInstance().put(null, "urn:ietf:params:xml:ns:domain-1.0", theTransMsg, null);
            }
            catch (EPPPollQueueException ex) {
                cat.error("doDomainCreate: Error adding transfer server approve poll message [" + theTransMsg + "]: " + ex);
                EPPResult theResult = new EPPResult(2400);
                EPPResponse theResponse = new EPPResponse(theTransId, theResult);
                return new EPPEventResponse(theResponse);
            }
        }
        EPPEventResponse theEventResponse = super.doDomainCreate(aEvent, aData);
        return theEventResponse;
    }

    @Override
    public EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        SessionData sessionData = (SessionData)aData;
        EPPDomainInfoCmd theCommand = (EPPDomainInfoCmd)aEvent.getMessage();
        cat.debug("doDomainInfo: command = [" + theCommand + "]");
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54322-XYZ");
        if (theCommand.getName().equalsIgnoreCase("un-no-dnssec.com") || theCommand.getName().equalsIgnoreCase("un-no-rgp.com")) {
            EPPDomainInfoResp theResponse = new EPPDomainInfoResp();
            theResponse.setName(theCommand.getName());
            theResponse.setRoid("EXAMPLE1-REP");
            theResponse.setRegistrant("jd1234");
            theResponse.addContact(new EPPDomainContact("sh8013", "admin"));
            theResponse.addContact(new EPPDomainContact("sh8013", "tech"));
            theResponse.addNs("ns1.example.com");
            theResponse.addNs("ns2.example.com");
            theResponse.addHost("ns1.example.com");
            theResponse.addHost("ns2.example.com");
            theResponse.setClientId("ClientX");
            theResponse.setCreatedBy("ClientY");
            theResponse.setLastUpdatedBy("ClientX");
            theResponse.setCreatedDate(new GregorianCalendar(1999, 4, 3).getTime());
            theResponse.setLastUpdatedDate(new GregorianCalendar(1999, 12, 3).getTime());
            theResponse.setLastTransferDate(new GregorianCalendar(2000, 4, 8).getTime());
            theResponse.setExpirationDate(new GregorianCalendar(2005, 4, 3).getTime());
            theResponse.setAuthInfo(new EPPAuthInfo("2fooBAR"));
            theResponse.setTransId(theTransId);
            theResponse.setResult(1000);
            if (theCommand.getName().equalsIgnoreCase("un-no-dnssec.com")) {
                theResponse.addStatus(new EPPDomainStatus("ok"));
                EPPSecDNSExtInfData dnssecData = new EPPSecDNSExtInfData();
                EPPSecDNSExtDsData dsData = new EPPSecDNSExtDsData(12345, 3, 1, "49FD46E6C4B45C55D4AC");
                dnssecData.appendDsData(dsData);
                theResponse.addExtension(dnssecData);
            } else {
                theResponse.addStatus(new EPPDomainStatus("pendingDelete"));
                EPPRgpExtInfData rgpExt = new EPPRgpExtInfData();
                EPPRgpExtStatus rgpStatus = new EPPRgpExtStatus();
                rgpStatus.setStatus("redemptionPeriod");
                rgpExt.addStatus(rgpStatus);
                theResponse.addExtension(rgpExt);
            }
            try {
                theResponse = (EPPDomainInfoResp)this.unhandledNamespaceFilter.filter(theResponse, sessionData.getLoginCmd().getExtensionServices(), aData);
            }
            catch (EPPException ex) {
                cat.error("UnhandledNamespacesDomainHandler.doDomainInfo(): Exception unhandled namespaces filtering response [" + theResponse + "]: " + ex);
                EPPResult theResult = new EPPResult(2400);
                EPPResponse theErrResponse = new EPPResponse(theTransId, theResult);
                return new EPPEventResponse(theErrResponse);
            }
            return new EPPEventResponse(theResponse);
        }
        return super.doDomainInfo(aEvent, aData);
    }
}

