/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPAuthInfo;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.nv.EPPDomainNameVerification;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckResp;
import com.verisign.epp.codec.nv.EPPNameVerificationCheckResult;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateFailed;
import com.verisign.epp.codec.nv.EPPNameVerificationCreatePending;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateResp;
import com.verisign.epp.codec.nv.EPPNameVerificationCreateSuccess;
import com.verisign.epp.codec.nv.EPPNameVerificationDocument;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoCmd;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoInputResult;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoResp;
import com.verisign.epp.codec.nv.EPPNameVerificationInfoSignedCodeResult;
import com.verisign.epp.codec.nv.EPPNameVerificationPendActionMsg;
import com.verisign.epp.codec.nv.EPPNameVerificationStatus;
import com.verisign.epp.codec.nv.EPPNameVerificationUpdateCmd;
import com.verisign.epp.codec.nv.EPPRealNameVerification;
import com.verisign.epp.codec.verificationcode.EPPEncodedSignedCodeValue;
import com.verisign.epp.codec.verificationcode.EPPSignedCode;
import com.verisign.epp.codec.verificationcode.VerificationCodeRevocationList;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPNameVerificationHandler;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.util.Date;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameVerificationHandler
extends EPPNameVerificationHandler {
    private static Logger cat = LoggerFactory.getLogger(NameVerificationHandler.class);
    private static PrivateKey privateKey;
    private static PublicKey publicKey;
    private static PKIXParameters pkixParameters;
    private static VerificationCodeRevocationList verificationCodeRevocationList;
    private static Certificate[] certChain;
    private static final String KEYSTORE_FILENAME = "verificationCode.jks";
    private static final String KEYSTORE_PASSWORD = "changeit";
    private static final String KEYSTORE_KEY_ALIAS = "verificationcode";
    private static final String KEYSTORE_CERT_ALIAS = "0:-1:china:domain~real-name:eppsdk:1";
    private static final String TRUSTSTORE_FILENAME = "verificationCode.jks";
    private static final String VSP_ID = "0";
    private static int checkResultCount;

    private EPPEncodedSignedCodeValue createSignedCode(String aCode, String aType) throws EPPException {
        cat.debug("createSignedCode: enter");
        cat.debug("createSignedCode: code = " + aCode + ", type = " + aType);
        System.out.println("createSignedCode: code = " + aCode + ", type = " + aType);
        EPPSignedCode signedCode = null;
        EPPEncodedSignedCodeValue encodedSignedCodeValue = null;
        try {
            signedCode = new EPPSignedCode(aCode, aType);
            signedCode.sign(privateKey, certChain);
            if (!signedCode.validate(publicKey)) {
                cat.error("Signed code validation error using public key");
                throw new EPPException("Signed code validation error using public key");
            }
            if (!signedCode.validate(pkixParameters)) {
                cat.error("Signed code validation error using PKIX");
                throw new EPPException("Signed code validation error using PKIX");
            }
            encodedSignedCodeValue = new EPPEncodedSignedCodeValue(signedCode);
            cat.debug("createSignedCode: encoded signed code value = [" + encodedSignedCodeValue + "]");
        }
        catch (EPPEncodeException e) {
            throw new EPPException("EPPEncodeException: " + e);
        }
        catch (EPPException e) {
            throw new EPPException("EPPException: " + e);
        }
        cat.debug("createSignedCode: exit");
        return encodedSignedCodeValue;
    }

    private static KeyStore.PrivateKeyEntry loadPrivateKeyEntry(String aKeyStoreName, String aKeyAliasName, String aPassword) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream keyStoreFile = new FileInputStream(aKeyStoreName);
        keyStore.load(keyStoreFile, aPassword.toCharArray());
        assert (keyStore.isKeyEntry(aKeyAliasName));
        KeyStore.PrivateKeyEntry keyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(aKeyAliasName, new KeyStore.PasswordProtection(aPassword.toCharArray()));
        return keyEntry;
    }

    public static PublicKey loadPublicKey(String aKeyStoreName, String aPublicKeyAlias) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream keyStoreFile = new FileInputStream(aKeyStoreName);
        keyStore.load(keyStoreFile, null);
        assert (keyStore.isCertificateEntry(aPublicKeyAlias));
        KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)keyStore.getEntry(aPublicKeyAlias, null);
        return certEntry.getTrustedCertificate().getPublicKey();
    }

    public static PKIXParameters loadPKIXParameters(String aTrustStoreName) throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream trustStoreFile = new FileInputStream(aTrustStoreName);
        trustStore.load(trustStoreFile, null);
        PKIXParameters pkixParameters = new PKIXParameters(trustStore);
        pkixParameters.setRevocationEnabled(false);
        return pkixParameters;
    }

    public NameVerificationHandler() {
        try {
            KeyStore.PrivateKeyEntry keyEntry = NameVerificationHandler.loadPrivateKeyEntry("verificationCode.jks", KEYSTORE_KEY_ALIAS, KEYSTORE_PASSWORD);
            privateKey = keyEntry.getPrivateKey();
            certChain = keyEntry.getCertificateChain();
            publicKey = NameVerificationHandler.loadPublicKey("verificationCode.jks", KEYSTORE_CERT_ALIAS);
            pkixParameters = NameVerificationHandler.loadPKIXParameters("verificationCode.jks");
        }
        catch (Exception ex) {
            Assert.fail((String)("Error loading keys for signing and validating: " + ex));
        }
        File verificationCodeRevocationListFile = new File("verification-code-test-revocation.csv");
        if (verificationCodeRevocationListFile.exists()) {
            try {
                FileInputStream smdRevocationListStream = new FileInputStream(verificationCodeRevocationListFile);
                verificationCodeRevocationList.decode(smdRevocationListStream);
            }
            catch (FileNotFoundException e) {
                Assert.fail((String)("Error opening Verification Code Revocation List File: " + e));
            }
            catch (EPPDecodeException e) {
                Assert.fail((String)("Error decoding Verification Code Revocation List File: " + e));
            }
        }
    }

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        super.preHandleEvent(aEvent, aData);
    }

    @Override
    protected EPPEventResponse doNameVerificationCheck(EPPEvent aEvent, Object aData) {
        cat.debug("doNameVerificationCheck: enter");
        EPPNameVerificationCheckCmd theCommand = (EPPNameVerificationCheckCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        EPPNameVerificationCheckResp theResp = new EPPNameVerificationCheckResp(theTransId);
        for (String label : theCommand.getLabels()) {
            if (label.startsWith("cvct")) {
                theResp.addResult(new EPPNameVerificationCheckResult(label, true));
                continue;
            }
            switch (checkResultCount % 3) {
                case 0: {
                    theResp.addResult(new EPPNameVerificationCheckResult(label, true));
                    break;
                }
                case 1: {
                    theResp.addResult(new EPPNameVerificationCheckResult(label, false, "In Prohibited Lists."));
                    break;
                }
                case 2: {
                    EPPNameVerificationCheckResult theCheckResult = new EPPNameVerificationCheckResult(label, false);
                    theCheckResult.setRestricted(true);
                    theResp.addResult(theCheckResult);
                }
            }
            ++checkResultCount;
        }
        cat.debug("doNameVerificationCheck: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doNameVerificationInfo(EPPEvent aEvent, Object aData) {
        EPPNameVerificationInfoResp theResp;
        cat.debug("doNameVerificationInfo: enter");
        EPPNameVerificationInfoCmd theCommand = (EPPNameVerificationInfoCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        if (theCommand.getInfoType() == EPPNameVerificationInfoCmd.Type.INPUT) {
            theResp = theCommand.getCode().contains("rnv") ? new EPPNameVerificationInfoResp(theTransId, new EPPNameVerificationInfoInputResult(new EPPRealNameVerification(EPPRealNameVerification.Role.PERSON, "John Xie", "1234567890", EPPRealNameVerification.ProofType.POC, new EPPNameVerificationDocument(EPPNameVerificationDocument.FileType.JPG, "EABQRAQAAAAAAAAAAAAAAAAAAAAD")), new EPPAuthInfo("2fooBAR"))) : new EPPNameVerificationInfoResp(theTransId, new EPPNameVerificationInfoInputResult(new EPPDomainNameVerification("example"), new EPPAuthInfo("2fooBAR")));
        } else {
            try {
                theResp = theCommand.getCode().contains("rnv") ? new EPPNameVerificationInfoResp(theTransId, new EPPNameVerificationInfoSignedCodeResult(theCommand.getCode(), "real-name", this.createSignedCode(theCommand.getCode(), "real-name"), EPPNameVerificationStatus.COMPLIANT, new EPPAuthInfo("2fooBAR"))) : new EPPNameVerificationInfoResp(theTransId, new EPPNameVerificationInfoSignedCodeResult(theCommand.getCode(), "domain", this.createSignedCode(theCommand.getCode(), "domain"), EPPNameVerificationStatus.COMPLIANT, new EPPAuthInfo("2fooBAR")));
            }
            catch (EPPException ex) {
                cat.error("Error creating the verification code info response:" + ex);
                EPPResult theResult = new EPPResult(2400);
                EPPResponse theResponse = new EPPResponse(theTransId, theResult);
                return new EPPEventResponse(theResponse);
            }
        }
        cat.debug("doNameVerificationInfo: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doNameVerificationCreate(EPPEvent aEvent, Object aData) {
        EPPNameVerificationCreateResp theResp;
        cat.debug("doNameVerificationCreate: enter");
        EPPNameVerificationCreateCmd theCommand = (EPPNameVerificationCreateCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        if (theCommand.hasDnv()) {
            cat.info("doNameVerificationCreate: Received DNV create with label = " + theCommand.getDnv().getName() + ", rnvCode = " + theCommand.getDnv().getRnvCode());
            if (theCommand.getDnv().getName().equalsIgnoreCase("PENDING")) {
                String theCode = "0-" + System.currentTimeMillis();
                EPPNameVerificationPendActionMsg thePollMsg = new EPPNameVerificationPendActionMsg(theTransId, theCode, "domain", EPPNameVerificationStatus.COMPLIANT, "The object has passed verification, signed code was generated.", new Date(System.currentTimeMillis()));
                try {
                    EPPPollQueueMgr.getInstance().put(null, "NameVerificationPollHandler", thePollMsg, null);
                }
                catch (EPPPollQueueException ex) {
                    cat.error("Error inserting poll queue message: " + ex);
                    EPPResult theResult = new EPPResult(2400);
                    EPPResponse theResponse = new EPPResponse(theTransId, theResult);
                    return new EPPEventResponse(theResponse);
                }
                theResp = new EPPNameVerificationCreateResp(theTransId, new EPPNameVerificationCreatePending(theCode, "domain", EPPNameVerificationStatus.PENDING_COMPLIANT, new Date(System.currentTimeMillis())));
                theResp.setResult(1001);
            } else if (theCommand.getDnv().getName().equalsIgnoreCase("FAILED")) {
                theResp = new EPPNameVerificationCreateResp(theTransId, new EPPNameVerificationCreateFailed(EPPNameVerificationStatus.NON_COMPLIANT, "The name of the object is not correct."));
                theResp.setResult(1000);
            } else if (theCommand.getDnv().getName().equalsIgnoreCase("INVALID-TYPE")) {
                try {
                    String theCode = "0-" + System.currentTimeMillis();
                    theResp = new EPPNameVerificationCreateResp(theTransId, new EPPNameVerificationCreateSuccess(theCode, "invalid-type", EPPNameVerificationStatus.COMPLIANT, new Date(System.currentTimeMillis()), this.createSignedCode(theCode, "invalid-type")));
                }
                catch (EPPException ex) {
                    cat.error("Error creating the DNV verification code create response:" + ex);
                    EPPResult theResult = new EPPResult(2400);
                    EPPResponse theResponse = new EPPResponse(theTransId, theResult);
                    return new EPPEventResponse(theResponse);
                }
            } else {
                try {
                    String theCode = "0-" + System.currentTimeMillis();
                    theResp = new EPPNameVerificationCreateResp(theTransId, new EPPNameVerificationCreateSuccess(theCode, "domain", EPPNameVerificationStatus.COMPLIANT, new Date(System.currentTimeMillis()), this.createSignedCode(theCode, "domain")));
                }
                catch (EPPException ex) {
                    cat.error("Error creating the DNV verification code create response:" + ex);
                    EPPResult theResult = new EPPResult(2400);
                    EPPResponse theResponse = new EPPResponse(theTransId, theResult);
                    return new EPPEventResponse(theResponse);
                }
            }
        } else {
            cat.info("doNameVerificationCreate: Received RNV create with role = " + theCommand.getRnv().getRole().toString() + ", name = " + theCommand.getRnv().getName() + ", num = " + theCommand.getRnv().getNum() + ", proofType = " + theCommand.getRnv().getProofType().toString());
            if (theCommand.getRnv().hasDocuments()) {
                for (EPPNameVerificationDocument doc : theCommand.getRnv().getDocuments()) {
                    cat.info("doNameVerificationCreate: doc type = " + doc.getFileType().toString() + ", content = \"" + doc.getFileContent() + "\"");
                }
            }
            try {
                String theCode = "0-" + System.currentTimeMillis();
                theResp = new EPPNameVerificationCreateResp(theTransId, new EPPNameVerificationCreateSuccess(theCode, "real-name", EPPNameVerificationStatus.COMPLIANT, new Date(System.currentTimeMillis()), this.createSignedCode(theCode, "real-name")));
            }
            catch (EPPException ex) {
                cat.error("Error creating the RNV verification code create response:" + ex);
                EPPResult theResult = new EPPResult(2400);
                EPPResponse theResponse = new EPPResponse(theTransId, theResult);
                return new EPPEventResponse(theResponse);
            }
        }
        cat.debug("doNameVerificationCreate: exit");
        return new EPPEventResponse(theResp);
    }

    @Override
    protected EPPEventResponse doNameVerificationUpdate(EPPEvent aEvent, Object aData) {
        cat.debug("doNameVerificationUpdate: enter");
        EPPNameVerificationUpdateCmd theCommand = (EPPNameVerificationUpdateCmd)aEvent.getMessage();
        EPPTransId theTransId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
        cat.info("doNameVerificationUpdate: code = " + theCommand.getCode() + ", authInfo = " + theCommand.getAuthInfo().getPassword());
        EPPResponse theResp = new EPPResponse(theTransId);
        cat.debug("doNameVerificationUpdate: exit");
        return new EPPEventResponse(theResp);
    }

    static {
        verificationCodeRevocationList = new VerificationCodeRevocationList();
        checkResultCount = 0;
    }
}

