/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.domain.EPPDomainCheckCmd;
import com.verisign.epp.codec.domain.EPPDomainCreateCmd;
import com.verisign.epp.codec.domain.EPPDomainDeleteCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoCmd;
import com.verisign.epp.codec.domain.EPPDomainInfoResp;
import com.verisign.epp.codec.domain.EPPDomainPendActionMsg;
import com.verisign.epp.codec.domain.EPPDomainUpdateCmd;
import com.verisign.epp.codec.gen.EPPCodec;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.launch.EPPLaunchCheck;
import com.verisign.epp.codec.launch.EPPLaunchCheckResult;
import com.verisign.epp.codec.launch.EPPLaunchChkData;
import com.verisign.epp.codec.launch.EPPLaunchCodeMark;
import com.verisign.epp.codec.launch.EPPLaunchCreData;
import com.verisign.epp.codec.launch.EPPLaunchCreate;
import com.verisign.epp.codec.launch.EPPLaunchDelete;
import com.verisign.epp.codec.launch.EPPLaunchInfData;
import com.verisign.epp.codec.launch.EPPLaunchInfo;
import com.verisign.epp.codec.launch.EPPLaunchNotice;
import com.verisign.epp.codec.launch.EPPLaunchStatus;
import com.verisign.epp.codec.launch.EPPLaunchUpdate;
import com.verisign.epp.codec.mark.EPPMark;
import com.verisign.epp.codec.mark.EPPMarkAddress;
import com.verisign.epp.codec.mark.EPPMarkContact;
import com.verisign.epp.codec.mark.EPPTrademark;
import com.verisign.epp.codec.signedMark.EPPEncodedSignedMark;
import com.verisign.epp.codec.signedMark.EPPSignedMark;
import com.verisign.epp.codec.signedMark.SMDRevocationList;
import com.verisign.epp.exception.EPPException;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPPollQueueException;
import com.verisign.epp.framework.EPPPollQueueMgr;
import com.verisign.epp.serverstub.DomainHandler;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.EPPSchemaCachingParser;
import com.verisign.epp.util.Environment;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXParameters;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.xerces.dom.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class LaunchDomainHandler
extends DomainHandler {
    private static Logger cat = LoggerFactory.getLogger(LaunchDomainHandler.class);
    private PKIXParameters pkixParameters;
    private SMDRevocationList smdRevocationList = new SMDRevocationList();

    public LaunchDomainHandler() {
        cat.debug("LaunchDomainHandler.LaunchDomainHandler(): enter");
        String truststore = Environment.getProperty("EPP.SignedMark.truststore");
        if (truststore == null) {
            cat.error("LaunchDomainHandler.LaunchDomainHandler(): EPP.SignedMark.truststore NOT defined in configuration");
            System.err.println("LaunchDomainHandler.LaunchDomainHandler(): EPP.SignedMark.truststore NOT defined in configuration");
            System.exit(1);
        }
        cat.debug("LaunchDomainHandler.LaunchDomainHandler(): Signed Mark Truststore = " + truststore);
        String crlsProp = Environment.getOption("EPP.SignedMark.crls");
        ArrayList<String> crls = new ArrayList<String>();
        if (crlsProp != null) {
            StringTokenizer tokenizer = new StringTokenizer(crlsProp, ",");
            while (tokenizer.hasMoreTokens()) {
                crls.add(tokenizer.nextToken());
            }
        }
        try {
            this.pkixParameters = this.loadPKIXParameters(truststore, crls);
        }
        catch (Exception ex) {
            cat.error("LaunchDomainHandler.LaunchDomainHandler(): Error loading the public key: " + ex);
            ex.printStackTrace();
            System.exit(1);
        }
        String revocationListProp = Environment.getOption("EPP.SignedMark.revocationList");
        if (revocationListProp == null) {
            File smdRevocationListFile = new File(revocationListProp);
            if (smdRevocationListFile.exists()) {
                try {
                    FileInputStream smdRevocationListStream = new FileInputStream(smdRevocationListFile);
                    this.smdRevocationList.decode(smdRevocationListStream);
                }
                catch (Exception ex) {
                    cat.error("LaunchDomainHandler.LaunchDomainHandler(): Error loading SMD revocation list : " + ex);
                    ex.printStackTrace();
                    System.exit(1);
                }
                cat.debug("LaunchDomainHandler.LaunchDomainHandler(): No SMD revocation list found");
            } else {
                cat.error("LaunchDomainHandler.LaunchDomainHandler(): Error finding SMD revocation list \"" + revocationListProp + "\"");
                System.exit(1);
            }
        } else {
            cat.debug("LaunchDomainHandler.LaunchDomainHandler(): EPP.SignedMark.revocationList property not defined");
        }
        cat.debug("LaunchDomainHandler.LaunchDomainHandler(): exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PKIXParameters loadPKIXParameters(String aTrustStoreName, List<String> aCrls) throws Exception {
        cat.debug("LaunchDomainHandler.loadPKIXParameters(String, String): enter");
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream trustStoreFile = new FileInputStream(aTrustStoreName);
        trustStore.load(trustStoreFile, null);
        trustStoreFile.close();
        cat.debug("LaunchDomainHandler.loadPKIXParameters(String, String): truststore = " + aTrustStoreName);
        PKIXParameters pkixParameters = new PKIXParameters(trustStore);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ArrayList<CRL> crlContentsList = new ArrayList<CRL>();
        for (String currCrl : aCrls) {
            File crlFile = new File(currCrl);
            if (crlFile.exists()) {
                InputStream inStream = null;
                try {
                    cat.debug("LaunchDomainHandler.loadPKIXParameters(String, String): adding CRL " + currCrl);
                    inStream = new FileInputStream(currCrl);
                    crlContentsList.add(certFactory.generateCRL(inStream));
                    continue;
                }
                finally {
                    if (inStream != null) {
                        inStream.close();
                    }
                    continue;
                }
            }
            throw new EPPException("CRL file " + currCrl + " does not exist.");
        }
        if (crlContentsList.size() != 0) {
            ArrayList<CertStore> certStores = new ArrayList<CertStore>();
            certStores.add(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crlContentsList)));
            pkixParameters.setCertStores(certStores);
            pkixParameters.setRevocationEnabled(true);
            cat.debug("LaunchDomainHandler.loadPKIXParameters(String, String): Revocation enabled");
        } else {
            pkixParameters.setRevocationEnabled(false);
            cat.debug("LaunchDomainHandler.loadPKIXParameters(String, String): Revocation disabled");
        }
        cat.debug("LaunchDomainHandler.loadPKIXParameters(String, String): exit");
        return pkixParameters;
    }

    private EPPEventResponse returnError(int aCode, String aClientTransId, String aReason) {
        cat.error("LaunchDomainHandler.returnError: code = " + aCode + ", reason = " + aReason);
        EPPResponse theResponse = new EPPResponse();
        EPPResult theResult = new EPPResult(aCode);
        theResult.addExtValueReason(aReason);
        theResponse.setResult(theResult);
        theResponse.setTransId(new EPPTransId(aClientTransId, "54321-XYZ"));
        return new EPPEventResponse(theResponse);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected EPPEventResponse doDomainCheck(EPPEvent aEvent, Object aData) {
        EPPEventResponse theEventResponse;
        cat.debug("LaunchDomainHandler.doDomainCheck: enter");
        EPPDomainCheckCmd theCommand = (EPPDomainCheckCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPLaunchCheck.class)) {
            EPPLaunchCheck theLaunchCheck = (EPPLaunchCheck)theCommand.getExtension(EPPLaunchCheck.class);
            if (!theLaunchCheck.hasType() || theLaunchCheck.getType().equals("claims")) {
                cat.debug("LaunchDomainHandler.doDomainCheck: Launch Claims Check Form for Phase = " + theLaunchCheck.getPhase());
                String phase = theLaunchCheck.getPhase().getPhase();
                if (!phase.equals("claims")) return this.returnError(2306, theCommand.getTransId(), "Unsupported check Phase = " + phase);
                EPPResponse theResponse = new EPPResponse(new EPPTransId(theCommand.getTransId(), "54321-XYZ"));
                EPPLaunchChkData theExt = new EPPLaunchChkData(theLaunchCheck.getPhase());
                boolean exists = true;
                boolean validatorId = true;
                Vector<String> vDomainNames = theCommand.getNames();
                Enumeration<String> eDomainNames = vDomainNames.elements();
                while (eDomainNames.hasMoreElements()) {
                    String domainName = eDomainNames.nextElement();
                    if (exists) {
                        if (validatorId) {
                            EPPLaunchCheckResult launchCheckResult = new EPPLaunchCheckResult(domainName, true);
                            launchCheckResult.addClaimKey(Base64.encodeBase64String((byte[])domainName.getBytes()), "tmch");
                            launchCheckResult.addClaimKey(Base64.encodeBase64String((byte[])domainName.getBytes()), "custom-tmch");
                            theExt.addCheckResult(launchCheckResult);
                        } else {
                            theExt.addCheckResult(new EPPLaunchCheckResult(domainName, true, Base64.encodeBase64String((byte[])domainName.getBytes())));
                        }
                        validatorId = !validatorId;
                    } else {
                        theExt.addCheckResult(new EPPLaunchCheckResult(domainName, false));
                    }
                    exists = !exists;
                }
                theResponse.addExtension(theExt);
                theEventResponse = new EPPEventResponse(theResponse);
            } else {
                cat.debug("LaunchDomainHandler.doDomainCheck: Launch Availability Check Form for Phase = " + theLaunchCheck.getPhase());
                theEventResponse = super.doDomainCheck(aEvent, aData);
            }
        } else {
            theEventResponse = super.doDomainCheck(aEvent, aData);
        }
        cat.debug("LaunchDomainHandler.doDomainCheck: exit");
        return theEventResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected EPPEventResponse doDomainInfo(EPPEvent aEvent, Object aData) {
        cat.debug("LaunchDomainHandler.doDomainInfo: enter");
        EPPLaunchInfData theRespExt = null;
        EPPDomainInfoCmd theCommand = (EPPDomainInfoCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPLaunchInfo.class)) {
            EPPLaunchInfo theCmdExt = (EPPLaunchInfo)theCommand.getExtension(EPPLaunchInfo.class);
            String applicationId = theCmdExt.getApplicationId();
            String phase = theCmdExt.getPhase().getPhase();
            if (phase.equals("sunrise")) {
                theRespExt = new EPPLaunchInfData();
                theRespExt.setPhase("sunrise");
                if (theCmdExt.isIncludeMark()) {
                    EPPTrademark trademark = new EPPTrademark();
                    trademark.setId("1234-2");
                    trademark.setName("Example One");
                    trademark.setJurisdiction("US");
                    trademark.addClass("35");
                    trademark.addClass("36");
                    trademark.addLabel("example-one");
                    trademark.addLabel("exampleone");
                    trademark.setGoodsAndServices("Dirigendas et eiusmodi featuring infringo in airfare et cartam servicia.");
                    trademark.setRegNum("234235");
                    trademark.setRegDate(new GregorianCalendar(2009, 8, 16).getTime());
                    trademark.setExDate(new GregorianCalendar(2015, 8, 16).getTime());
                    EPPMarkContact holder = new EPPMarkContact();
                    holder.setOrg("Example Inc.");
                    EPPMarkAddress holderAddress = new EPPMarkAddress();
                    holderAddress.addStreet("123 Example Dr.");
                    holderAddress.addStreet("Suite 100");
                    holderAddress.setCity("Reston");
                    holderAddress.setSp("VA");
                    holderAddress.setPc("20190");
                    holderAddress.setCc("US");
                    holder.setAddress(holderAddress);
                    trademark.addHolder(holder);
                    EPPMarkContact contact = new EPPMarkContact();
                    contact.setName("John Doe");
                    contact.setOrg("Example Inc.");
                    EPPMarkAddress contactAddress = new EPPMarkAddress();
                    contactAddress.addStreet("123 Example Dr.");
                    contactAddress.addStreet("Suite 100");
                    contactAddress.setCity("Reston");
                    contactAddress.setSp("VA");
                    contactAddress.setPc("20166-6503");
                    contactAddress.setCc("US");
                    contact.setAddress(contactAddress);
                    contact.setVoice("+1.7035555555");
                    contact.setVoiceExt("1234");
                    contact.setFax("+1.7035555556");
                    contact.setEmail("jdoe@example.tld");
                    trademark.addContact(contact);
                    EPPMark mark = new EPPMark();
                    mark.addTrademark(trademark);
                    theRespExt.addMark(mark);
                }
                if (applicationId != null) {
                    theRespExt.setStatus("pendingValidation");
                    theRespExt.setApplicationId(applicationId);
                }
            } else {
                if (!phase.equals("landrush")) return this.returnError(2306, theCommand.getTransId(), "Unsupported Info Phase = " + phase);
                theRespExt = new EPPLaunchInfData();
                theRespExt.setPhase("landrush");
                if (applicationId == null) return this.returnError(2306, theCommand.getTransId(), "Info with landrush phase must include applicationId");
                theRespExt.setStatus("pendingValidation");
                theRespExt.setApplicationId(applicationId);
            }
        } else {
            cat.debug("LaunchDomainHandler.doDomainInfo: No EPPLaunchInfo extension passed");
        }
        EPPEventResponse theEventResponse = super.doDomainInfo(aEvent, aData);
        EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
        if (theRespExt != null) {
            theResponse.addExtension(theRespExt);
        }
        cat.debug("LaunchDomainHandler.doDomainInfo: exit");
        return theEventResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected EPPEventResponse doDomainCreate(EPPEvent aEvent, Object aData) {
        EPPEventResponse theEventResponse;
        block32: {
            boolean isApp;
            EPPLaunchCreate theCmdExt;
            EPPDomainCreateCmd theCommand;
            block38: {
                Object theParser;
                block37: {
                    Iterator<EPPLaunchCodeMark> iterator;
                    block36: {
                        block33: {
                            String phase;
                            block34: {
                                block35: {
                                    cat.debug("LaunchDomainHandler.doDomainCreate: enter");
                                    theEventResponse = null;
                                    theCommand = (EPPDomainCreateCmd)aEvent.getMessage();
                                    if (!theCommand.hasExtension(EPPLaunchCreate.class)) break block33;
                                    theCmdExt = (EPPLaunchCreate)theCommand.getExtension(EPPLaunchCreate.class);
                                    phase = theCmdExt.getPhase().getPhase();
                                    isApp = new Random().nextBoolean();
                                    if (theCmdExt.hasType()) {
                                        isApp = theCmdExt.getType().equals("application");
                                    }
                                    if (!phase.equals("sunrise")) break block34;
                                    String domainName = theCommand.getName().toUpperCase();
                                    if (!theCmdExt.hasCodeMarks()) break block35;
                                    List<EPPLaunchCodeMark> codeMarks = theCmdExt.getCodeMarks();
                                    if (codeMarks.size() == 0) {
                                        return this.returnError(2306, theCommand.getTransId(), "No codeMarks provided");
                                    }
                                    iterator = codeMarks.iterator();
                                    break block36;
                                }
                                if (!theCmdExt.hasSignedMarks()) {
                                    return this.returnError(2306, theCommand.getTransId(), "No mark information provided");
                                }
                                List<EPPSignedMark> signedMarks = theCmdExt.getSignedMarks();
                                if (signedMarks.size() == 0) {
                                    return this.returnError(2306, theCommand.getTransId(), "No signed marks provided");
                                }
                                if (!(signedMarks.get(0) instanceof EPPEncodedSignedMark) && aData != null && aData instanceof SessionData && ((SessionData)aData).getAttribute("PACKET") != null) {
                                    theParser = new EPPSchemaCachingParser();
                                    try {
                                        ((EPPSchemaCachingParser)theParser).setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
                                        SessionData sessionData = (SessionData)aData;
                                        byte[] packet = (byte[])sessionData.getAttribute("PACKET");
                                        cat.debug("Command with signed mark = [" + new String(packet) + "]");
                                        Document theDoc = ((EPPSchemaCachingParser)theParser).parse(new ByteArrayInputStream(packet));
                                        EPPDomainCreateCmd theCreateCmd = (EPPDomainCreateCmd)EPPCodec.getInstance().decode(theDoc);
                                        signedMarks = ((EPPLaunchCreate)theCreateCmd.getExtension(EPPLaunchCreate.class)).getSignedMarks();
                                    }
                                    catch (Exception e) {
                                        cat.error("LaunchDomainHandler.doDomainCreate: Error decoding XML signed mark: " + e);
                                        return this.returnError(2400, theCommand.getTransId(), "Error decoding XML signed mark");
                                    }
                                }
                                theParser = signedMarks.iterator();
                                break block37;
                            }
                            if (phase.equals("claims")) {
                                if (theCmdExt.hasNotice()) {
                                    for (EPPLaunchNotice notice : theCmdExt.getNotices()) {
                                        if (notice.hasValidatorId()) {
                                            cat.debug("LaunchDomainHandler.doDomainCreate: validator id = [" + notice.getValidatorId() + "]");
                                        }
                                        cat.debug("LaunchDomainHandler.doDomainCreate: notice id = [" + notice.getNoticeId() + "]");
                                        cat.debug("LaunchDomainHandler.doDomainCreate: notice not after date = [" + EPPUtil.encodeTimeInstant(notice.getNotAfterDate()) + "]");
                                        cat.debug("LaunchDomainHandler.doDomainCreate: notice accepted date = [" + EPPUtil.encodeTimeInstant(notice.getAcceptedDate()) + "]");
                                    }
                                }
                                if (isApp) {
                                    Random random = new Random();
                                    String applicationId = System.currentTimeMillis() + "-" + random.nextInt();
                                    EPPLaunchCreData respExt = new EPPLaunchCreData(theCmdExt.getPhase(), applicationId);
                                    theEventResponse = super.doDomainCreate(aEvent, aData);
                                    EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
                                    theResponse.addExtension(respExt);
                                    theResponse.setResult(1001);
                                    break block32;
                                } else {
                                    theEventResponse = super.doDomainCreate(aEvent, aData);
                                }
                                break block32;
                            } else {
                                cat.debug("LaunchDomainHandler.doDomainCreate: phase = " + phase);
                                if (isApp) {
                                    Random random = new Random();
                                    String applicationId = System.currentTimeMillis() + "-" + random.nextInt();
                                    EPPLaunchCreData respExt = new EPPLaunchCreData(theCmdExt.getPhase(), applicationId);
                                    theEventResponse = super.doDomainCreate(aEvent, aData);
                                    EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
                                    theResponse.addExtension(respExt);
                                    theResponse.setResult(1001);
                                    break block32;
                                } else {
                                    theEventResponse = super.doDomainCreate(aEvent, aData);
                                }
                            }
                            break block32;
                        }
                        theEventResponse = super.doDomainCreate(aEvent, aData);
                        break block32;
                    }
                    while (iterator.hasNext()) {
                        EPPLaunchCodeMark codeMark = iterator.next();
                        if (codeMark.hasCodeMark()) {
                            cat.debug("LaunchDomainHandler.doDomainCreate: code = [" + codeMark.getCode() + "]");
                            cat.debug("LaunchDomainHandler.doDomainCreate: mark = [" + codeMark.getMark() + "]");
                            continue;
                        }
                        if (codeMark.hasCode()) {
                            cat.debug("LaunchDomainHandler.doDomainCreate: code = [" + codeMark.getCode() + "]");
                            continue;
                        }
                        if (!codeMark.hasMark()) {
                            return this.returnError(2004, theCommand.getTransId(), "codeMark does not having any codes or marks");
                        }
                        cat.debug("LaunchDomainHandler.doDomainCreate: mark = [" + codeMark.getMark() + "]");
                    }
                    break block38;
                }
                while (theParser.hasNext()) {
                    String signedMarkXML;
                    EPPSignedMark signedMark = theParser.next();
                    cat.debug("LaunchDomainHandler.doDomainCreate: signedMark = [" + signedMark + "]");
                    DocumentImpl doc = new DocumentImpl();
                    try {
                        signedMarkXML = EPPUtil.toStringNoIndent(signedMark.encode((Document)doc));
                    }
                    catch (EPPEncodeException e) {
                        cat.error("LaunchDomainHandler.doDomainCreate: Error re-encoding signed mark: " + e);
                        return this.returnError(2400, theCommand.getTransId(), "Error re-encoding signed mark");
                    }
                    System.out.println("\nLaunchDomainHandler.doDomainCreate: signed mark = \n" + signedMarkXML);
                    System.out.println("\nLaunchDomainHandler.doDomainCreate: base64 signed mark = \n" + new String(Base64.encodeBase64((byte[])signedMarkXML.getBytes(), (boolean)true)));
                    if (!signedMark.validate(this.pkixParameters)) {
                        cat.error("LaunchDomainHandler.doDomainCreate: Signature is NOT valid");
                        return this.returnError(2306, theCommand.getTransId(), "Signed mark signature invalid");
                    }
                    cat.debug("LaunchDomainHandler.doDomainCreate: Signature is valid");
                    if (this.smdRevocationList.isRevoked(signedMark)) {
                        cat.debug("LaunchDomainHandler.doDomainCreate: signed mark is revoked");
                        return this.returnError(2306, theCommand.getTransId(), "Signed mark is revoked");
                    }
                    cat.debug("LaunchDomainHandler.doDomainCreate: signed mark is not revoked");
                }
            }
            theEventResponse = super.doDomainCreate(aEvent, aData);
            EPPResponse theResponse = (EPPResponse)theEventResponse.getResponse();
            if (isApp) {
                Random random = new Random();
                String applicationId = System.currentTimeMillis() + "-" + random.nextInt();
                EPPLaunchCreData respExt = new EPPLaunchCreData(theCmdExt.getPhase(), applicationId);
                theResponse.addExtension(respExt);
                theResponse.setResult(1001);
                try {
                    EPPDomainInfoResp thePollMsg;
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), "54322-XYZ");
                    if (theCommand.getName().equals("APPPENDINGALLOCATION.TLD")) {
                        thePollMsg = new EPPDomainInfoResp();
                        thePollMsg.setTransId(transId);
                        thePollMsg.setName(theCommand.getName());
                        thePollMsg.setRoid("EXAMPLE1-REP");
                        thePollMsg.setClientId("ClientX");
                        thePollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("validated")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePollMsg, null);
                        thePollMsg = new EPPDomainInfoResp();
                        thePollMsg.setTransId(transId);
                        thePollMsg.setName(theCommand.getName());
                        thePollMsg.setRoid("EXAMPLE1-REP");
                        thePollMsg.setClientId("ClientX");
                        thePollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("pendingAllocation")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePollMsg, null);
                        break block32;
                    }
                    if (theCommand.getName().equals("APPREJECTEDINVALID.TLD")) {
                        thePollMsg = new EPPDomainInfoResp();
                        thePollMsg.setTransId(transId);
                        thePollMsg.setName(theCommand.getName());
                        thePollMsg.setRoid("EXAMPLE1-REP");
                        thePollMsg.setClientId("ClientX");
                        thePollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("invalid")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePollMsg, null);
                        EPPResponse cmdResp = (EPPResponse)theEventResponse.getResponse();
                        EPPTransId cmdRespTransId = (EPPTransId)cmdResp.getTransId().clone();
                        EPPDomainPendActionMsg thePendActionPollMsg = new EPPDomainPendActionMsg(transId, theCommand.getName(), false, cmdRespTransId, new Date());
                        thePendActionPollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("rejected")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePendActionPollMsg, null);
                        break block32;
                    }
                    if (theCommand.getName().equals("APPALLOCATEDALLSTATES.TLD")) {
                        thePollMsg = new EPPDomainInfoResp();
                        thePollMsg.setName(theCommand.getName());
                        thePollMsg.setRoid("EXAMPLE1-REP");
                        thePollMsg.setClientId("ClientX");
                        thePollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("validated")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePollMsg, null);
                        thePollMsg = new EPPDomainInfoResp();
                        thePollMsg.setName(theCommand.getName());
                        thePollMsg.setRoid("EXAMPLE1-REP");
                        thePollMsg.setClientId("ClientX");
                        thePollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("pendingAllocation")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePollMsg, null);
                        EPPResponse cmdResp = (EPPResponse)theEventResponse.getResponse();
                        EPPTransId cmdRespTransId = (EPPTransId)cmdResp.getTransId().clone();
                        EPPDomainPendActionMsg thePendActionPollMsg = new EPPDomainPendActionMsg(transId, theCommand.getName(), true, cmdRespTransId, new Date());
                        thePendActionPollMsg.addExtension(new EPPLaunchInfData(theCmdExt.getPhase(), applicationId, new EPPLaunchStatus("allocated")));
                        EPPPollQueueMgr.getInstance().put(null, "LaunchPollHandler", thePendActionPollMsg, null);
                    }
                }
                catch (EPPPollQueueException ex) {
                    return this.returnError(2400, theCommand.getTransId(), "Poll queue error: " + ex);
                }
                catch (CloneNotSupportedException ex) {
                    return this.returnError(2400, theCommand.getTransId(), "Error cloning object: " + ex);
                }
            }
        }
        cat.debug("LaunchDomainHandler.doDomainDelete: exit");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainDelete(EPPEvent aEvent, Object aData) {
        cat.debug("LaunchDomainHandler.doDomainDelete: enter");
        EPPDomainDeleteCmd theCommand = (EPPDomainDeleteCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPLaunchDelete.class)) {
            EPPLaunchDelete theCmdExt = (EPPLaunchDelete)theCommand.getExtension(EPPLaunchDelete.class);
            String applicationId = theCmdExt.getApplicationId();
            String phase = theCmdExt.getPhase().getPhase();
            if (phase.equals("sunrise") || phase.equals("landrush")) {
                if (applicationId != null) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
                    EPPResponse theResponse = new EPPResponse(transId);
                    theResponse.setResult(1000);
                    cat.debug("LaunchDomainHandler.doDomainDelete: exit - application");
                    return new EPPEventResponse(theResponse);
                }
                return this.returnError(2306, theCommand.getTransId(), "Delete with " + phase + " phase must include applicationId");
            }
            return this.returnError(2306, theCommand.getTransId(), "Unsupported Delete Phase = " + phase);
        }
        cat.debug("LaunchDomainHandler.doDomainDelete: No EPPLaunchDelete extension passed");
        EPPEventResponse theEventResponse = super.doDomainDelete(aEvent, aData);
        cat.debug("LaunchDomainHandler.doDomainDelete: exit");
        return theEventResponse;
    }

    @Override
    protected EPPEventResponse doDomainUpdate(EPPEvent aEvent, Object aData) {
        cat.debug("LaunchDomainHandler.doDomainUpdate: enter");
        EPPDomainUpdateCmd theCommand = (EPPDomainUpdateCmd)aEvent.getMessage();
        if (theCommand.hasExtension(EPPLaunchUpdate.class)) {
            EPPLaunchUpdate theCmdExt = (EPPLaunchUpdate)theCommand.getExtension(EPPLaunchUpdate.class);
            String applicationId = theCmdExt.getApplicationId();
            String phase = theCmdExt.getPhase().getPhase();
            if (phase.equals("sunrise") || phase.equals("landrush")) {
                if (applicationId != null) {
                    EPPTransId transId = new EPPTransId(theCommand.getTransId(), "54321-XYZ");
                    EPPResponse theResponse = new EPPResponse(transId);
                    theResponse.setResult(1000);
                    cat.debug("LaunchDomainHandler.doDomainUpdate: exit - application");
                    return new EPPEventResponse(theResponse);
                }
                return this.returnError(2306, theCommand.getTransId(), "Update with " + phase + " phase must include applicationId");
            }
            return this.returnError(2306, theCommand.getTransId(), "Unsupported Update Phase = " + phase);
        }
        cat.debug("LaunchDomainHandler.doDomainUpdate: No EPPLaunchUpdate extension passed");
        EPPEventResponse theEventResponse = super.doDomainUpdate(aEvent, aData);
        cat.debug("LaunchDomainHandler.doDomainUpdate: exit");
        return theEventResponse;
    }
}

