/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.host.EPPHostAddress;
import com.verisign.epp.codec.host.EPPHostCheckCmd;
import com.verisign.epp.codec.host.EPPHostCheckResp;
import com.verisign.epp.codec.host.EPPHostCheckResult;
import com.verisign.epp.codec.host.EPPHostCreateCmd;
import com.verisign.epp.codec.host.EPPHostCreateResp;
import com.verisign.epp.codec.host.EPPHostDeleteCmd;
import com.verisign.epp.codec.host.EPPHostInfoCmd;
import com.verisign.epp.codec.host.EPPHostInfoResp;
import com.verisign.epp.codec.host.EPPHostStatus;
import com.verisign.epp.codec.host.EPPHostUpdateCmd;
import com.verisign.epp.framework.EPPEvent;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.EPPHandleEventException;
import com.verisign.epp.framework.EPPHostHandler;
import com.verisign.epp.serverstub.SessionData;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class HostHandler
extends EPPHostHandler {
    private static final String svrTransId = "54322-XYZ";
    private static final String roid = "NS1EXAMPLE1-VRSN";

    @Override
    protected void preHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
        SessionData sessionData = (SessionData)aData;
        EPPCommand theMessage = (EPPCommand)aEvent.getMessage();
        if (!sessionData.isLoggedIn()) {
            EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
            EPPResponse theResponse = new EPPResponse(transId);
            theResponse.setResult(2500);
            throw new EPPHandleEventException("The client has not established a session", theResponse);
        }
    }

    @Override
    protected void postHandleEvent(EPPEvent aEvent, Object aData) throws EPPHandleEventException {
    }

    @Override
    protected EPPEventResponse doHostUpdate(EPPEvent aEvent, Object aData) {
        EPPHostUpdateCmd theMessage = (EPPHostUpdateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doHostInfo(EPPEvent aEvent, Object aData) {
        EPPHostInfoCmd theMessage = (EPPHostInfoCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPHostInfoResp theResponse = new EPPHostInfoResp();
        theResponse.setTransId(transId);
        theResponse.setName(theMessage.getName());
        theResponse.setRoid(roid);
        theResponse.setCreatedBy("createdByLloyd");
        theResponse.setCreatedDate(new Date());
        theResponse.setClientId("clientidX");
        Vector<EPPHostStatus> statuses = new Vector<EPPHostStatus>();
        statuses.addElement(new EPPHostStatus("linked"));
        statuses.addElement(new EPPHostStatus("clientUpdateProhibited"));
        theResponse.setStatuses(statuses);
        Vector<EPPHostAddress> addresses = new Vector<EPPHostAddress>();
        addresses.addElement(new EPPHostAddress("192.1.2.3"));
        theResponse.setAddresses(addresses);
        theResponse.setLastUpdatedBy("updatedX");
        theResponse.setLastUpdatedDate(new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doHostDelete(EPPEvent aEvent, Object aData) {
        EPPHostDeleteCmd theMessage = (EPPHostDeleteCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPResponse theResponse = new EPPResponse(transId);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doHostCheck(EPPEvent aEvent, Object aData) {
        EPPHostCheckCmd theMessage = (EPPHostCheckCmd)aEvent.getMessage();
        Vector<String> hosts = theMessage.getNames();
        Enumeration<String> eHosts = hosts.elements();
        Vector<EPPHostCheckResult> vResults = new Vector<EPPHostCheckResult>();
        boolean available = true;
        while (eHosts.hasMoreElements()) {
            String hostName = eHosts.nextElement();
            available = !available;
            vResults.addElement(new EPPHostCheckResult(hostName, available));
        }
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPHostCheckResp theResponse = new EPPHostCheckResp(transId, vResults);
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }

    @Override
    protected EPPEventResponse doHostCreate(EPPEvent aEvent, Object aData) {
        EPPHostCreateCmd theMessage = (EPPHostCreateCmd)aEvent.getMessage();
        EPPTransId transId = new EPPTransId(theMessage.getTransId(), svrTransId);
        EPPHostCreateResp theResponse = new EPPHostCreateResp(transId, theMessage.getName(), new Date());
        theResponse.setResult(1000);
        return new EPPEventResponse(theResponse);
    }
}

