/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPDcp;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPPurpose;
import com.verisign.epp.codec.gen.EPPRecipient;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPStatement;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.framework.EPPByteArrayDispatcher;
import com.verisign.epp.framework.EPPDispatcher;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.framework.EPPEventResponse;
import com.verisign.epp.framework.HttpEPPXMLAssembler;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.util.EPPEnv;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerServlet
extends HttpServlet {
    private static Logger cat = LoggerFactory.getLogger(ControllerServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException, IOException {
        SessionData theSessionData;
        cat.debug("doPost: <<< Received Request >>");
        ServletInputStream theInputStream = null;
        ServletOutputStream theOutputStream = null;
        try {
            theInputStream = aRequest.getInputStream();
            theOutputStream = aResponse.getOutputStream();
        }
        catch (IOException e) {
            cat.error("doPost: Exception getting input and output streams for client request");
            e.printStackTrace();
            return;
        }
        HttpSession theHttpSession = aRequest.getSession(false);
        if (theHttpSession == null) {
            this.sendErrorResponse(2002, "Command use error", (OutputStream)theOutputStream, new SessionData());
            cat.error("doPost: No HTTP session established on POST");
            return;
        }
        HttpSession httpSession = theHttpSession;
        synchronized (httpSession) {
            theSessionData = (SessionData)theHttpSession.getAttribute("sessionData");
            if (theSessionData == null) {
                cat.debug("doPost: No session context exists, creating session context");
                theSessionData = new SessionData();
                theHttpSession.setAttribute("sessionData", (Object)theSessionData);
            }
        }
        cat.debug("Processing command");
        byte[] theRequestPacket = theInputStream.readAllBytes();
        byte[] theResponsePacket = null;
        try {
            theResponsePacket = EPPByteArrayDispatcher.getInstance().processMessage(theRequestPacket, theSessionData);
            if (theResponsePacket != null) {
                aResponse.addHeader("Content-Type", "application/epp+xml;charset=UTF-8");
                aResponse.addHeader("Cache-Control", "no-cache");
                aResponse.addHeader("Expires", "0");
                theOutputStream.write(theResponsePacket);
            } else {
                cat.info("doPost: null response packet");
            }
        }
        catch (EPPAssemblerException | EPPEventException e) {
            cat.error("doPost: Exception processing command: " + e);
            this.sendErrorResponse(2400, "Error processing command", (OutputStream)theOutputStream, theSessionData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest aRequest, HttpServletResponse aResponse) throws ServletException, IOException {
        ServletOutputStream theOutputStream = null;
        try {
            theOutputStream = aResponse.getOutputStream();
        }
        catch (IOException e) {
            cat.error("Exception getting output streams for client request");
            e.printStackTrace();
            return;
        }
        HttpSession theHttpSession = null;
        SessionData theSessionData = null;
        try {
            cat.info("Establishing HTTP session");
            theHttpSession = aRequest.getSession(true);
            EPPGreeting theGreeting = new EPPGreeting();
            theGreeting.setServer(EPPEnv.getGreetingServerName());
            EPPDcp theDCP = new EPPDcp();
            theDCP.setAccess((short)0);
            EPPStatement theStatement = new EPPStatement();
            EPPPurpose thePurpose = new EPPPurpose();
            thePurpose.setAdmin(true);
            thePurpose.setProv(true);
            theStatement.setPurpose(thePurpose);
            EPPRecipient theRecipient = new EPPRecipient();
            theRecipient.addOurs(null);
            theRecipient.setPublic(true);
            theStatement.setRecipient(theRecipient);
            theStatement.setRetention((short)4);
            theDCP.addStatement(theStatement);
            theGreeting.setDcp(theDCP);
            theSessionData = new SessionData();
            theSessionData.setGreeting(theGreeting);
            HttpSession httpSession = theHttpSession;
            synchronized (httpSession) {
                theHttpSession.setAttribute("sessionData", (Object)theSessionData);
            }
            aResponse.addHeader("Content-Type", "application/epp+xml;charset=UTF-8");
            aResponse.addHeader("Cache-Control", "no-cache");
            aResponse.addHeader("Expires", "0");
            EPPEventResponse theEventResponse = new EPPEventResponse(theGreeting);
            HttpEPPXMLAssembler theAssembler = new HttpEPPXMLAssembler();
            byte[] theGreetingPacket = theAssembler.encode(theEventResponse, theSessionData);
            theOutputStream.write(theGreetingPacket);
        }
        catch (EPPAssemblerException e) {
            cat.error("doPost: Exception encoding EPP Greeting: " + e);
            this.sendErrorResponse(2400, "Error processing connection", (OutputStream)theOutputStream, theSessionData);
        }
    }

    private void sendErrorResponse(int aCode, String aDescription, OutputStream out, SessionData aSessionData) {
        cat.debug("Enter sendErrorResponse()");
        cat.debug("Sending error response to client, code = " + aCode + ", description = " + aDescription);
        EPPResult theResult = new EPPResult(aCode);
        theResult.addExtValueReason(aDescription);
        EPPTransId theTransId = new EPPTransId("svrTrans1");
        EPPResponse response = new EPPResponse(theTransId, theResult);
        try {
            EPPDispatcher.getInstance().send(response, out, aSessionData);
            out.flush();
        }
        catch (Exception e) {
            cat.debug(".sendErrorResponse() Error sending error response to client: " + e);
        }
        cat.debug(".sendErrorResponse() Return");
    }
}

