/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.serverstub;

import com.verisign.epp.codec.gen.EPPDcp;
import com.verisign.epp.codec.gen.EPPGreeting;
import com.verisign.epp.codec.gen.EPPPurpose;
import com.verisign.epp.codec.gen.EPPRecipient;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPResult;
import com.verisign.epp.codec.gen.EPPStatement;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.framework.EPPAssemblerException;
import com.verisign.epp.framework.EPPDispatcher;
import com.verisign.epp.framework.EPPEventException;
import com.verisign.epp.serverstub.SessionData;
import com.verisign.epp.transport.ServerEventHandler;
import com.verisign.epp.util.EPPEnv;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionHandler
implements ServerEventHandler,
Cloneable {
    private static Logger cat = LoggerFactory.getLogger(ClientConnectionHandler.class);
    private static final int TIMEOUT_MINUTES = 3;
    private boolean running = true;
    private int SessionCommandCount = 0;
    private SessionData sessionData = new SessionData();
    private GregorianCalendar idleTimeOutTime = new GregorianCalendar();

    public ClientConnectionHandler() {
        this.idleTimeOutTime.add(12, 3);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ClientConnectionHandler theCopy = (ClientConnectionHandler)super.clone();
        theCopy.sessionData = (SessionData)this.sessionData.clone();
        theCopy.idleTimeOutTime = (GregorianCalendar)this.idleTimeOutTime.clone();
        return theCopy;
    }

    @Override
    public void handleConnection(InputStream aInputStream, OutputStream aOutputStream) {
        cat.debug("Server accepted new connection. Thread id is: " + Thread.currentThread().hashCode());
        EPPGreeting greeting = new EPPGreeting();
        int threadId = Thread.currentThread().hashCode();
        greeting.setServer(EPPEnv.getGreetingServerName());
        cat.debug("Server name = " + greeting.getServer());
        EPPDcp theDCP = new EPPDcp();
        theDCP.setAccess((short)0);
        EPPStatement theStatement = new EPPStatement();
        EPPPurpose thePurpose = new EPPPurpose();
        thePurpose.setAdmin(true);
        thePurpose.setProv(true);
        theStatement.setPurpose(thePurpose);
        EPPRecipient theRecipient = new EPPRecipient();
        theRecipient.addOurs(null);
        theRecipient.setPublic(true);
        theStatement.setRecipient(theRecipient);
        theStatement.setRetention((short)4);
        theDCP.addStatement(theStatement);
        greeting.setDcp(theDCP);
        this.sessionData.setGreeting(greeting);
        this.idleTimeOutTime = new GregorianCalendar();
        this.idleTimeOutTime.add(12, 3);
        EPPDispatcher theDispatcher = EPPDispatcher.getInstance();
        theDispatcher.processConnection(aInputStream, aOutputStream, this.sessionData);
        while (this.running) {
            try {
                theDispatcher.processMessage(aInputStream, aOutputStream, this.sessionData);
                ++this.SessionCommandCount;
                this.resetIdleTimeOut();
                this.running = !this.sessionData.hasLogoutOccured();
            }
            catch (EPPEventException e) {
                cat.error("EPP Event Exception", (Throwable)e);
                this.sendErrorResponse(2400, "Internal Server Error, EPP Event Exception: " + e.getMessage(), aOutputStream, this.sessionData);
            }
            catch (EPPAssemblerException ex) {
                if (ex.equals(EPPAssemblerException.FATAL)) {
                    cat.error("Fatal EPPAssemblerException caught stopping client thread", (Throwable)ex);
                    this.sendErrorResponse(2400, "Internal Server Error, EPPAssemblerException: " + ex.getMessage(), aOutputStream, this.sessionData);
                    this.running = false;
                    continue;
                }
                if (ex.equals(EPPAssemblerException.XML)) {
                    cat.error("EPPAssemblerException.XML, sending COMMAND_SYNTAX_ERROR response to client");
                    this.sendErrorResponse(2001, "XML Schema Validation Error, " + ex.getMessage(), aOutputStream, this.sessionData);
                    continue;
                }
                if (ex.equals(EPPAssemblerException.MISSINGPARAMETER)) {
                    cat.error("EPPAssemblerException.MISSINGPARAMETER, sending MISSINGPARAMETER response to client");
                    this.sendErrorResponse(2003, "Command processing error, , " + ex.getMessage(), aOutputStream, this.sessionData);
                    continue;
                }
                if (ex.equals(EPPAssemblerException.COMMANDNOTFOUND)) {
                    cat.error("EPPAssemblerException.COMMANDNOTFOUND, sending UNIMPLEMENTED_COMMAND response to client");
                    this.sendErrorResponse(2101, "Command not found, " + ex.getMessage(), aOutputStream, this.sessionData);
                    continue;
                }
                if (ex.equals(EPPAssemblerException.EXTENSIONNOTFOUND)) {
                    cat.error("EPPAssemblerException.EXTENSIONNOTFOUND, sending UNIMPLEMENTED_EXTENSION response to client");
                    this.sendErrorResponse(2103, "Extension not found, " + ex.getMessage(), aOutputStream, this.sessionData);
                    continue;
                }
                if (ex.equals(EPPAssemblerException.CLOSECON)) {
                    cat.error("EPPAssemblerException.CLOSECON caught, stopping thread");
                    this.running = false;
                    continue;
                }
                if (ex.equals(EPPAssemblerException.INTRUPTEDIO)) {
                    cat.debug("EPPAssemblerException.INTRUPTEDIO caught, no command received");
                    continue;
                }
                cat.error("Unknown EPPAssemblerException type");
                this.sendErrorResponse(2400, "Internal Server Error, Unknown EPPAssemblerException" + ex.getMessage(), aOutputStream, this.sessionData);
            }
        }
        cat.debug("Server closed connection. Thread id is: " + Thread.currentThread().hashCode());
    }

    private void sendErrorResponse(int aCode, String aDescription, OutputStream out, SessionData aSessionData) {
        cat.debug("<<<<<<<<<<<<<<<<<<<<<<  Enter sendErrorResponse()>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        cat.debug("Sending error response to client, code = " + aCode + ", description = " + aDescription);
        EPPResult theResult = new EPPResult(aCode);
        if (aDescription != null) {
            theResult.addExtValueReason(aDescription);
        }
        EPPTransId theTransId = new EPPTransId("svrError1");
        EPPResponse response = new EPPResponse(theTransId, theResult);
        try {
            EPPDispatcher.getInstance().send(response, out);
            out.flush();
        }
        catch (Exception e) {
            cat.debug("sendErrorResponse(): Error sending error response to client: ");
        }
        cat.debug("sendErrorResponse(): Return");
    }

    public void close() {
        this.running = false;
    }

    protected void resetIdleTimeOut() {
        this.idleTimeOutTime.setTime(new Date());
        this.idleTimeOutTime.add(12, 3);
    }
}

